/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.fetch;

import com.google.common.collect.Lists;
import com.kenshoo.jooq.DataTable;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.internal.fetch.BFS;
import com.kenshoo.pl.entity.internal.fetch.OneToOneTableRelation;
import com.kenshoo.pl.entity.internal.fetch.ToEdgesOf;
import com.kenshoo.pl.entity.internal.fetch.TreeEdge;
import com.kenshoo.pl.entity.internal.fetch.TreeNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jooq.lambda.Seq;
import org.jooq.lambda.function.Functions;
import org.jooq.lambda.tuple.Tuple2;

public class ExecutionPlan {
    private final OneToOnePlan oneToOnePlan;
    private final List<ManyToOnePlan<?>> manyToOnePlans;

    public ExecutionPlan(DataTable startingTable, Collection<? extends EntityField<?, ?>> fieldsToFetch) {
        Map<DataTable, List<EntityField<?, ?>>> remainingPrimaryTables = this.targetTableToFieldsOf(fieldsToFetch, startingTable);
        TreeEdge startingEdge = new TreeEdge(null, startingTable);
        ArrayList oneToOnePaths = Lists.newArrayList();
        ArrayList manyToOneCandidates = Lists.newArrayList();
        BFS.visit(startingEdge, this::edgesComingOutOf).limitUntil(__ -> remainingPrimaryTables.isEmpty()).forEach(currentEdge -> {
            DataTable table = currentEdge.target.table;
            List fields = (List)remainingPrimaryTables.get(table);
            if (currentEdge != startingEdge && fields != null) {
                remainingPrimaryTables.remove(table);
                oneToOnePaths.add(currentEdge);
            }
            Seq.seq((Map)remainingPrimaryTables).filter(this.referencing(table)).forEach(manyToOneEntry -> {
                TreeEdge sourceEdge = currentEdge == startingEdge ? null : currentEdge;
                manyToOneCandidates.add(new ManyToOnePlan(new TreeEdge(new TreeNode(sourceEdge, table), (DataTable)manyToOneEntry.v1), (List)manyToOneEntry.v2));
            });
        });
        if (Seq.seq(remainingPrimaryTables.keySet()).anyMatch(this.notMany(manyToOneCandidates))) {
            throw new IllegalStateException("Some tables " + remainingPrimaryTables + " could not be reached via joins");
        }
        List oneToOneFields = Seq.seq(fieldsToFetch).filter(this.tableIn(oneToOnePaths).or(this.tableEqual(startingTable))).toList();
        this.oneToOnePlan = new OneToOnePlan(oneToOnePaths, oneToOneFields, this.oneToOneSecondaryTablesOf(fieldsToFetch));
        this.manyToOnePlans = Seq.seq((Iterable)manyToOneCandidates).filter(this.notIn(oneToOnePaths)).toList();
    }

    public OneToOnePlan getOneToOnePlan() {
        return this.oneToOnePlan;
    }

    public List<ManyToOnePlan<?>> getManyToOnePlans() {
        return this.manyToOnePlans;
    }

    private Map<DataTable, ? extends List<? extends EntityField<?, ?>>> targetTableToFieldsOf(Collection<? extends EntityField<?, ?>> fieldsToFetch, DataTable startingTable) {
        return Seq.seq(fieldsToFetch).filter(field -> !field.getEntityType().getPrimaryTable().equals(startingTable)).groupBy(this::parimaryTableOf);
    }

    private Set<OneToOneTableRelation> oneToOneSecondaryTablesOf(Collection<? extends EntityField<?, ?>> fields) {
        return fields.stream().filter(Functions.not(this.isOfPrimaryTable())).map(field -> OneToOneTableRelation.builder().secondary(field.getDbAdapter().getTable()).primary(field.getEntityType().getPrimaryTable()).build()).collect(Collectors.toSet());
    }

    private Predicate<EntityField<?, ?>> isOfPrimaryTable() {
        return field -> field.getDbAdapter().getTable().equals(field.getEntityType().getPrimaryTable());
    }

    private DataTable parimaryTableOf(EntityField<?, ?> field) {
        return field.getEntityType().getPrimaryTable();
    }

    private Predicate<? super Tuple2<DataTable, ? extends List<? extends EntityField<?, ?>>>> referencing(DataTable table) {
        return entry -> ((DataTable)entry.v1).getReferencesTo(table).size() == 1;
    }

    private Predicate<EntityField<?, ?>> tableIn(List<TreeEdge> oneToOnePaths) {
        return field -> Seq.seq((Iterable)oneToOnePaths).anyMatch(path -> field.getEntityType().getPrimaryTable().equals(path.target.table));
    }

    private Predicate<EntityField<?, ?>> tableEqual(DataTable table) {
        return field -> table.equals(field.getEntityType().getPrimaryTable());
    }

    private Predicate<DataTable> notMany(List<ManyToOnePlan<?>> manyToOnePlans) {
        return table -> Seq.seq((Iterable)manyToOnePlans).noneMatch(plan -> table.equals(plan.getPath().target.table));
    }

    private Predicate<ManyToOnePlan<?>> notIn(List<TreeEdge> oneToOnePaths) {
        return plan -> Seq.seq((Iterable)oneToOnePaths).noneMatch(path -> plan.getPath().target.table.equals(path.target.table));
    }

    private Seq<TreeEdge> edgesComingOutOf(TreeEdge edge) {
        return Seq.seq((Iterable)edge.target.table.getReferences()).map((Function)new ToEdgesOf(edge.target));
    }

    public static class OneToOnePlan {
        private final List<TreeEdge> paths;
        private final List<? extends EntityField<?, ?>> fields;
        private final Set<OneToOneTableRelation> secondaryTableRelations;

        OneToOnePlan(List<TreeEdge> paths, List<? extends EntityField<?, ?>> fields, Set<OneToOneTableRelation> secondaryTableRelations) {
            this.paths = paths;
            this.fields = fields;
            this.secondaryTableRelations = secondaryTableRelations;
        }

        public List<TreeEdge> getPaths() {
            return this.paths;
        }

        public List<? extends EntityField<?, ?>> getFields() {
            return this.fields;
        }

        public Set<OneToOneTableRelation> getSecondaryTableRelations() {
            return this.secondaryTableRelations;
        }
    }

    public static class ManyToOnePlan<E extends EntityType<E>> {
        private final TreeEdge path;
        private final List<? extends EntityField<E, ?>> fields;

        ManyToOnePlan(TreeEdge path, List<? extends EntityField<E, ?>> fields) {
            this.path = path;
            this.fields = fields;
        }

        public TreeEdge getPath() {
            return this.path;
        }

        public List<? extends EntityField<E, ?>> getFields() {
            return this.fields;
        }
    }
}

