/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.fetch;

import com.google.common.collect.Iterators;
import com.kenshoo.pl.entity.CurrentEntityMutableState;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.FieldsValueMapImpl;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.UniqueKey;
import com.kenshoo.pl.entity.internal.fetch.AliasedKey;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.jooq.Record;
import org.jooq.lambda.Seq;

public class RecordReader {
    public static <E extends EntityType<E>> Identifier<E> createKey(Record record, AliasedKey<E> aliasedKey) {
        FieldsValueMapImpl fieldsValueMap = new FieldsValueMapImpl();
        aliasedKey.fields().forEach(aliasedField -> RecordReader.populateMap(aliasedField.unAliased(), aliasedField.aliased().getName(), record, fieldsValueMap));
        return new UniqueKey(aliasedKey.unAliasedFields()).createIdentifier(fieldsValueMap);
    }

    public static CurrentEntityState createEntity(Record record, Collection<? extends EntityField<?, ?>> fields) {
        CurrentEntityMutableState currentState = new CurrentEntityMutableState();
        Iterator valuesIterator = record.intoList().iterator();
        fields.forEach(field -> RecordReader.populateEntity(field, valuesIterator, currentState));
        return currentState;
    }

    public static <E extends EntityType<E>> FieldsValueMap<E> createFieldsValueMap(Record record, List<? extends EntityField<E, ?>> fields) {
        FieldsValueMapImpl fieldsValueMap = new FieldsValueMapImpl();
        Iterator valuesIterator = record.intoList().iterator();
        Seq.seq(fields).forEach(field -> RecordReader.populateMap(field, valuesIterator, fieldsValueMap));
        return fieldsValueMap;
    }

    private static <E extends EntityType<E>, T> void populateMap(EntityField<E, T> field, String aliasName, Record record, FieldsValueMapImpl<E> fieldsValueMap) {
        T value = field.getDbAdapter().getFromRecord((Iterator<Object>)Iterators.singletonIterator((Object)record.getValue(aliasName)));
        fieldsValueMap.set(field, value);
    }

    private static <E extends EntityType<E>, T> void populateEntity(EntityField<E, T> entityField, Iterator<Object> valuesIterator, CurrentEntityMutableState currentState) {
        currentState.set(entityField, entityField.getDbAdapter().getFromRecord(valuesIterator));
    }

    private static <E extends EntityType<E>, T> void populateMap(EntityField<E, T> field, Iterator<Object> valuesIterator, FieldsValueMapImpl<E> fieldsValueMap) {
        fieldsValueMap.set(field, field.getDbAdapter().getFromRecord(valuesIterator));
    }
}

