/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.internal.validators;

import com.google.common.collect.ImmutableMap;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.SupportedChangeOperation;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.internal.validators.ChangeValidatorAdapter;
import com.kenshoo.pl.entity.internal.validators.ValidationTrigger;
import com.kenshoo.pl.entity.spi.RequiredFieldValidator;
import java.util.Map;
import java.util.stream.Stream;

public class RequiredFieldValidationAdapter<E extends EntityType<E>, T>
implements ChangeValidatorAdapter<E> {
    private final RequiredFieldValidator<E, T> validator;

    public RequiredFieldValidationAdapter(RequiredFieldValidator<E, T> validator) {
        this.validator = validator;
    }

    @Override
    public ValidationTrigger<E> trigger() {
        return entityFields -> true;
    }

    @Override
    public SupportedChangeOperation getSupportedChangeOperation() {
        return SupportedChangeOperation.CREATE;
    }

    @Override
    public Stream<? extends EntityField<?, ?>> fieldsToFetch() {
        return this.validator.fetchFields();
    }

    @Override
    public ValidationError validate(EntityChange<E> entityChange, CurrentEntityState currentState) {
        if (this.isFieldNotSpecified(entityChange) && this.validator.requireWhen().test(currentState)) {
            return new ValidationError(this.validator.getErrorCode(), this.validator.requiredField(), (Map<String, String>)ImmutableMap.of((Object)"field", (Object)this.validator.requiredField().toString()));
        }
        return null;
    }

    private boolean isFieldNotSpecified(EntityChange<E> entityChange) {
        return entityChange.safeGet(this.validator.requiredField()).isNullOrAbsent();
    }
}

