/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.spi;

import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.spi.FetchEntityFields;
import com.kenshoo.pl.entity.spi.NotSuppliedException;
import com.kenshoo.pl.entity.spi.ValidationException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;

public interface FieldValueSupplier<T>
extends FetchEntityFields {
    public T supply(CurrentEntityState var1) throws ValidationException, NotSuppliedException;

    public static <OLD_VAL, NEW_VAL> FieldValueSupplier<NEW_VAL> fromOldValue(final EntityField<?, OLD_VAL> field, final Function<OLD_VAL, NEW_VAL> func) {
        return new FieldValueSupplier<NEW_VAL>(){

            @Override
            public NEW_VAL supply(CurrentEntityState oldState) throws ValidationException, NotSuppliedException {
                return func.apply(oldState.get(field));
            }

            @Override
            public Stream<EntityField<?, ?>> fetchFields(ChangeOperation changeOperation) {
                return Stream.of(field);
            }
        };
    }

    public static <T1, T2, RES> FieldValueSupplier<RES> fromValues(final EntityField<?, T1> field1, final EntityField<?, T2> field2, final BiFunction<T1, T2, RES> func) {
        return new FieldValueSupplier<RES>(){

            @Override
            public RES supply(CurrentEntityState oldState) throws ValidationException, NotSuppliedException {
                return func.apply(oldState.get(field1), oldState.get(field2));
            }

            @Override
            public Stream<EntityField<?, ?>> fetchFields(ChangeOperation changeOperation) {
                return Stream.of(field1, field2);
            }
        };
    }
}

