/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.entity.spi.helpers;

import com.google.common.collect.Sets;
import com.kenshoo.pl.entity.ChangeResult;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.EntityChangeResult;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.ValidationError;
import com.kenshoo.pl.entity.spi.helpers.ObservedResult;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeResultInspector<E extends EntityType<E>> {
    private static final Logger logger = LoggerFactory.getLogger(ChangeResultInspector.class);
    public static final String VALUE_NOT_FOUND = "not found";
    public static final ValidationError UNEXPECTED_ERROR = new ValidationError("Unexpected error");
    private final Set<EntityField<E, ?>> inspectedFields;
    private final String inspectedFlow;

    public ChangeResultInspector(Set<EntityField<E, ?>> inspectedFields, String inspectedFlow) {
        this.inspectedFields = inspectedFields;
        this.inspectedFlow = inspectedFlow;
    }

    public void inspect(Map<? extends Identifier<E>, CurrentEntityState> originalState, ChangeResult<E, ?, ?> results, List<ObservedResult<E>> observedResults) {
        Iterator<EntityChangeResult<E, ?, ?>> resultIterator = results.iterator();
        Iterator<ObservedResult<E>> observedResultIterator = observedResults.iterator();
        while (resultIterator.hasNext() && observedResultIterator.hasNext()) {
            EntityChangeResult<E, ?, ?> result = resultIterator.next();
            ObservedResult<E> observedResult = observedResultIterator.next();
            if (result.isSuccess() && observedResult.isSuccess()) {
                this.inspectResult(originalState.get(result.getIdentifier()), result, observedResult);
                continue;
            }
            if (result.isSuccess()) {
                this.logResultWarning(observedResult.getIdentifier(), observedResult.getErrorCode().orElse(""), true, false);
                observedResult.setInspectedStatus(ObservedResult.InspectedStatus.LEGACY_ERROR_MISMATCH);
                continue;
            }
            if (!observedResult.isSuccess()) continue;
            Optional<ValidationError> firstError = result.getErrors().stream().findAny();
            this.logResultWarning(observedResult.getIdentifier(), firstError.orElse(UNEXPECTED_ERROR).getErrorCode(), false, true);
            observedResult.setInspectedStatus(ObservedResult.InspectedStatus.PERSISTENCE_ERROR_MISMATCH);
        }
    }

    public static void logException(String inspectedFlow, Throwable t) {
        logger.warn("Change result inspector can't inspect keyword changes for flow " + inspectedFlow, t);
    }

    private void inspectResult(CurrentEntityState originalEntity, EntityChangeResult<E, ?, ?> result, ObservedResult<E> observedResult) {
        Object command = result.getCommand();
        this.inspectedFields.forEach(field -> {
            Object observedValue;
            Object originalValue;
            boolean fieldChanged = command.isFieldChanged(field);
            boolean containsObservedField = observedResult.containsField(field);
            if (fieldChanged && containsObservedField) {
                Object observedValue2;
                Object value = this.getValue((FieldsValueMap<E>)command, (EntityField)field);
                if (!Objects.equals(value, observedValue2 = this.getValue(observedResult, (EntityField)field))) {
                    this.logFieldWarning(observedResult.getIdentifier(), field.toString(), value, observedValue2);
                    observedResult.setInspectedStatus(ObservedResult.InspectedStatus.VALUE_MISMATCH);
                }
            } else if (fieldChanged) {
                Object value = this.getValue((FieldsValueMap<E>)command, (EntityField)field);
                this.logFieldWarning(observedResult.getIdentifier(), field.toString(), value, VALUE_NOT_FOUND);
                observedResult.setInspectedStatus(ObservedResult.InspectedStatus.VALUE_MISMATCH);
            } else if (containsObservedField && !Objects.equals(originalValue = originalEntity.containsField((EntityField<?, ?>)field) ? this.getValue(originalEntity, (EntityField)field) : null, observedValue = this.getValue(observedResult, (EntityField)field))) {
                this.logFieldWarning(observedResult.getIdentifier(), field.toString(), VALUE_NOT_FOUND, observedValue);
                observedResult.setInspectedStatus(ObservedResult.InspectedStatus.VALUE_MISMATCH);
            }
        });
    }

    private <T> Object getValue(CurrentEntityState fieldsValueMap, EntityField<E, T> field) {
        return field.getDbAdapter().getDbValues(fieldsValueMap.get(field)).collect(Collectors.toList()).get(0);
    }

    private <T> Object getValue(FieldsValueMap<E> fieldsValueMap, EntityField<E, T> field) {
        return field.getDbAdapter().getDbValues(fieldsValueMap.get(field)).collect(Collectors.toList()).get(0);
    }

    private void logFieldWarning(Identifier<E> identifier, String fieldName, Object value, Object observedValue) {
        logger.warn("Change result inspector reports different value result for flow {} and identifier {} for field {} : legacy {}, persistent {}", new Object[]{this.inspectedFlow, identifier.toString(), fieldName, observedValue, value});
    }

    private void logResultWarning(Identifier<E> identifier, String errorCode, boolean success, boolean inspectedSuccess) {
        logger.warn("Change result inspector reports validation mismatch for flow {} and identifier {} : legacy result [{}], persistent result [{}], error {}", new Object[]{this.inspectedFlow, identifier.toString(), inspectedSuccess, success, errorCode});
    }

    public static class Builder<E extends EntityType<E>> {
        private Set<EntityField<E, ?>> inspectedFields = Sets.newHashSet();
        private String inspectedFlow;

        public final Builder<E> withInspectedFields(Collection<EntityField<E, ?>> fields) {
            this.inspectedFields.addAll(fields);
            return this;
        }

        public Builder<E> inspectedFlow(String inspectedFlow) {
            this.inspectedFlow = inspectedFlow;
            return this;
        }

        public ChangeResultInspector<E> build() {
            return new ChangeResultInspector<E>(this.inspectedFields, this.inspectedFlow);
        }
    }
}

