/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.simulation;

import com.google.common.annotations.VisibleForTesting;
import com.kenshoo.pl.entity.ChangeFlowConfig;
import com.kenshoo.pl.entity.CreateEntityCommand;
import com.kenshoo.pl.entity.Entity;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.FieldsValueMap;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.PLContext;
import com.kenshoo.pl.entity.PersistenceLayer;
import com.kenshoo.pl.entity.UniqueKey;
import com.kenshoo.pl.entity.UniqueKeyValue;
import com.kenshoo.pl.entity.UpdateEntityCommand;
import com.kenshoo.pl.entity.internal.EntitiesFetcher;
import com.kenshoo.pl.simulation.ActualDatabaseMutator;
import com.kenshoo.pl.simulation.ComparisonMismatch;
import com.kenshoo.pl.simulation.internal.ActualResultFetcher;
import com.kenshoo.pl.simulation.internal.FakeAutoIncGenerator;
import com.kenshoo.pl.simulation.internal.InitialStateRecorder;
import com.kenshoo.pl.simulation.internal.ResultComparator;
import com.kenshoo.pl.simulation.internal.SimulatedResult;
import com.kenshoo.pl.simulation.internal.ValueOrException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jooq.lambda.Seq;

public class DualRunSimulator<E extends EntityType<E>> {
    private final Collection<EntityField<E, ?>> inspectedFields;
    private final ChangeFlowConfig.Builder<E> flowToSimulate;
    private final PersistenceLayer<E> pl;
    private final ActualResultFetcher<E> actualResultFetcher;
    private final ResultComparator<E> resultComparator;

    public DualRunSimulator(PLContext plContext, ChangeFlowConfig.Builder<E> flowToSimulate, Collection<EntityField<E, ?>> inspectedFields) {
        this.inspectedFields = inspectedFields;
        this.flowToSimulate = flowToSimulate;
        this.actualResultFetcher = new ActualResultFetcher(new EntitiesFetcher(plContext.dslContext()), inspectedFields);
        this.pl = new PersistenceLayer(plContext);
        this.resultComparator = new ResultComparator(inspectedFields);
    }

    @VisibleForTesting
    DualRunSimulator(PLContext plContext, ChangeFlowConfig.Builder<E> flowToSimulate, Collection<EntityField<E, ?>> inspectedFields, ActualResultFetcher<E> actualResultFetcher, ResultComparator<E> resultComparator) {
        this.inspectedFields = inspectedFields;
        this.flowToSimulate = flowToSimulate;
        this.actualResultFetcher = actualResultFetcher;
        this.resultComparator = resultComparator;
        this.pl = new PersistenceLayer(plContext);
    }

    public List<ComparisonMismatch<E>> runCreation(UniqueKey<E> uniqueKey, ActualDatabaseMutator<E> databaseMutator, Collection<? extends CreateEntityCommand<E>> commandsToSimulate) {
        ChangeFlowConfig<E> plFlow = this.flowToSimulate.withoutOutputGenerators().withOutputGenerator(new FakeAutoIncGenerator<E>(uniqueKey.getEntityType())).build();
        ValueOrException<List> simulatedResults = ValueOrException.tryGet(() -> (List)Seq.seq(this.pl.create(commandsToSimulate, plFlow, uniqueKey).getChangeResults()).map(res -> new SimulatedResult(res.getCommand(), uniqueKey.createIdentifier((FieldsValueMap)res.getCommand()), res.getErrors())).collect(Collectors.toList()));
        Map actualErrors = Seq.seq(databaseMutator.run()).toMap(__ -> __.getId());
        ValueOrException<Iterable> actualResults = ValueOrException.tryGet(() -> this.actualResultFetcher.fetch(this.idsOf((Collection)simulatedResults.value()), actualErrors, this::emptyOriginalState));
        return ValueOrException.tryGet(() -> this.resultComparator.findMismatches((Iterable)simulatedResults.value(), (Iterable)actualResults.value())).orWhenException(this::comparisionError);
    }

    public <ID extends Identifier<E>> List<ComparisonMismatch<E>> runUpdate(ActualDatabaseMutator<E> databaseMutator, Collection<? extends UpdateEntityCommand<E, ID>> commandsToSimulate) {
        InitialStateRecorder<E> originalStateRecorder = new InitialStateRecorder<E>(this.inspectedFields);
        ChangeFlowConfig<E> plFlow = this.flowToSimulate.withoutOutputGenerators().withOutputGenerator(originalStateRecorder).build();
        ValueOrException<List> simulatedResults = ValueOrException.tryGet(() -> (List)Seq.seq(this.pl.update(commandsToSimulate, plFlow).getChangeResults()).map(r -> new SimulatedResult(r.getCommand(), r.getIdentifier(), r.getErrors())).collect(Collectors.toList()));
        Map actualErrors = Seq.seq(databaseMutator.run()).toMap(__ -> __.getId());
        ValueOrException<Iterable> actualResults = ValueOrException.tryGet(() -> this.actualResultFetcher.fetch(this.idsOf((Collection)simulatedResults.value()), actualErrors, originalStateRecorder::get));
        return ValueOrException.tryGet(() -> this.resultComparator.findMismatches((Iterable)simulatedResults.value(), (Iterable)actualResults.value())).orWhenException(this::comparisionError);
    }

    private List<Identifier<E>> idsOf(Collection<SimulatedResult<E>> simulatedResults) {
        return Seq.seq(simulatedResults).map(SimulatedResult::getId).toList();
    }

    private Entity emptyState() {
        return new Entity(){

            @Override
            public boolean containsField(EntityField<?, ?> field) {
                return false;
            }

            @Override
            public <T> T get(EntityField<?, T> field) {
                return null;
            }
        };
    }

    private Entity emptyOriginalState(Identifier<E> id) {
        return this.emptyState();
    }

    private List<ComparisonMismatch<E>> comparisionError(Throwable exception) {
        return Collections.singletonList(new ComparisonMismatch(UniqueKeyValue.empty(), "Simulation crashed: " + exception.getMessage() + "\n" + ExceptionUtils.getStackTrace((Throwable)exception)));
    }
}

