/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.simulation.internal;

import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.Entity;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.internal.EntitiesFetcher;
import com.kenshoo.pl.simulation.ActualMutatorError;
import com.kenshoo.pl.simulation.internal.ActualError;
import com.kenshoo.pl.simulation.internal.ActualResult;
import com.kenshoo.pl.simulation.internal.ActualSuccess;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import org.jooq.lambda.Seq;

public class ActualResultFetcher<E extends EntityType<E>> {
    private final EntitiesFetcher fetcher;
    private final Collection<EntityField<E, ?>> inspectedFields;

    public ActualResultFetcher(EntitiesFetcher fetcher, Collection<EntityField<E, ?>> inspectedFields) {
        this.fetcher = fetcher;
        this.inspectedFields = inspectedFields;
    }

    public Iterable<ActualResult> fetch(Collection<? extends Identifier<E>> allIds, Map<Identifier<E>, ActualMutatorError<E>> errors, Function<Identifier<E>, Entity> originalStates) {
        Map finalStates = this.fetcher.fetchEntitiesByIds(allIds, this.inspectedFields);
        return Seq.seq(allIds).map(id -> {
            Entity originalState = (Entity)originalStates.apply((Identifier)id);
            CurrentEntityState finalState = (CurrentEntityState)finalStates.get(id);
            if (errors.containsKey(id)) {
                return new ActualError(((ActualMutatorError)errors.get(id)).getDescription());
            }
            if (originalState == null) {
                return new ActualError("Could not find original state");
            }
            if (finalState == null) {
                return new ActualError("Could not find final state");
            }
            return new ActualSuccess(originalState, finalState);
        });
    }
}

