/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.simulation.internal;

import com.google.common.collect.Maps;
import com.kenshoo.pl.entity.ChangeContext;
import com.kenshoo.pl.entity.ChangeOperation;
import com.kenshoo.pl.entity.CurrentEntityState;
import com.kenshoo.pl.entity.Entity;
import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.entity.Identifier;
import com.kenshoo.pl.entity.spi.OutputGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class InitialStateRecorder<E extends EntityType<E>>
implements OutputGenerator<E> {
    private final Collection<EntityField<E, ?>> fields;
    private Map<Identifier<E>, CurrentEntityState> entities = Maps.newHashMap();

    public InitialStateRecorder(Collection<EntityField<E, ?>> fields) {
        this.fields = fields;
    }

    @Override
    public void generate(Collection<? extends EntityChange<E>> commands, ChangeOperation op, ChangeContext ctx) {
        this.entities = commands.stream().collect(Collectors.toMap(EntityChange::getIdentifier, ctx::getEntity));
    }

    @Override
    public Stream<? extends EntityField<?, ?>> requiredFields(Collection<? extends EntityField<E, ?>> fieldsToUpdate, ChangeOperation changeOperation) {
        return this.requiredFields();
    }

    public Entity get(Identifier<E> id) {
        return this.entities.get(id);
    }

    private Stream<? extends EntityField<?, ?>> requiredFields() {
        return this.fields.stream();
    }
}

