/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.simulation.internal;

import com.kenshoo.pl.entity.EntityChange;
import com.kenshoo.pl.entity.EntityField;
import com.kenshoo.pl.entity.EntityType;
import com.kenshoo.pl.simulation.ComparisonMismatch;
import com.kenshoo.pl.simulation.internal.ActualResult;
import com.kenshoo.pl.simulation.internal.SimulatedResult;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jooq.lambda.Seq;

public class ResultComparator<E extends EntityType<E>> {
    private final Collection<EntityField<E, ?>> inspectedFields;

    public ResultComparator(Collection<EntityField<E, ?>> inspectedFields) {
        this.inspectedFields = inspectedFields;
    }

    public List<ComparisonMismatch<E>> findMismatches(Iterable<SimulatedResult<E>> simulatedResults, Iterable<ActualResult> actualDbResults) {
        return (List)Seq.seq(simulatedResults).zip(actualDbResults).map(pair -> this.findMismatch((SimulatedResult)pair.v1, (ActualResult)pair.v2)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Optional<ComparisonMismatch<E>> findMismatch(SimulatedResult<E> simulatedResult, ActualResult actualResult) {
        if (simulatedResult.isError() && actualResult.isError()) {
            return Optional.empty();
        }
        if (simulatedResult.isSuccess() && actualResult.isError()) {
            return Optional.of(new ComparisonMismatch<E>(simulatedResult.getId(), "Simulated mutation was successful but real mutation finished with the following error: " + actualResult.getErrorDescription()));
        }
        if (simulatedResult.isError() && actualResult.isSuccess()) {
            return Optional.of(new ComparisonMismatch<E>(simulatedResult.getId(), "Real mutation was successful but simulated mutation finished with the following errors: " + simulatedResult.getErrors()));
        }
        List mismatchingFields = this.inspectedFields.stream().map(field -> this.getFieldMismatch((EntityField<E, ?>)field, simulatedResult.getCommand(), actualResult)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        return mismatchingFields.isEmpty() ? Optional.empty() : Optional.of(new ComparisonMismatch<E>(simulatedResult.getId(), "Found field mismatch: " + mismatchingFields));
    }

    private Optional<String> getFieldMismatch(EntityField<E, ?> field, EntityChange<E> simulated, ActualResult actualResult) {
        if (!simulated.isFieldChanged(field) && !actualResult.isReallyChanged(field)) {
            return Optional.empty();
        }
        if (!simulated.isFieldChanged(field) && actualResult.isReallyChanged(field)) {
            return Optional.of("Field \"" + field + "\" is not populated in the simulated command although it was changed in DB");
        }
        return Objects.equals(simulated.get(field), actualResult.getFinalValue(field)) ? Optional.empty() : Optional.of("Field \"" + field + "\" has mismatch values. Simulated: \"" + simulated.get(field) + "\", Actual: \"" + actualResult.getFinalValue(field) + "\"");
    }
}

