/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.pl.simulation.internal;

import java.util.concurrent.Callable;
import java.util.function.Function;

public class ValueOrException<T> {
    private final T value;
    private final Exception exception;

    private ValueOrException(T value, Exception exception) {
        this.value = value;
        this.exception = exception;
    }

    public static <V> ValueOrException<V> of(V value) {
        return new ValueOrException<V>(value, null);
    }

    public static <V> ValueOrException<V> error(Exception exception) {
        return new ValueOrException<Object>(null, exception);
    }

    public T value() throws Exception {
        if (this.exception != null) {
            throw this.exception;
        }
        return this.value;
    }

    public T orWhenException(Function<Exception, T> handler) {
        return this.exception == null ? this.value : handler.apply(this.exception);
    }

    public static <T> ValueOrException<T> tryGet(Callable<T> callable) {
        try {
            return ValueOrException.of(callable.call());
        }
        catch (Exception exception) {
            return ValueOrException.error(exception);
        }
    }
}

