/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.xlsx2csv;

import com.google.common.collect.Lists;
import com.kenshoo.xlsx2csv.BooleanCellDataHandler;
import com.kenshoo.xlsx2csv.CellDataHandler;
import com.kenshoo.xlsx2csv.DateCellDataHandler;
import com.kenshoo.xlsx2csv.NumberCellDataHandler;
import com.monitorjbl.xlsx.impl.StreamingCell;
import java.util.List;

public class CellHandler {
    private List<CellDataHandler> cellDataHandlers = Lists.newArrayList();

    public CellHandler() {
        this.cellDataHandlers.add(new BooleanCellDataHandler());
        this.cellDataHandlers.add(new DateCellDataHandler());
        this.cellDataHandlers.add(new NumberCellDataHandler());
    }

    public String getDataFromCell(StreamingCell cell) {
        return cell == null ? "" : this.cellDataHandlers.stream().filter(cellDataHandler -> cellDataHandler.isMatchingCellType(cell)).findFirst().map(cellDataHandler -> cellDataHandler.handleCell(cell)).orElse(this.getDefaultData(cell));
    }

    private String getDefaultData(StreamingCell cell) {
        return (String)cell.getRawContents();
    }
}

