/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.xlsx2csv;

import com.kenshoo.xlsx2csv.CellDataHandler;
import com.monitorjbl.xlsx.impl.StreamingCell;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DateCellDataHandler
implements CellDataHandler {
    private static final Logger logger = LoggerFactory.getLogger(DateCellDataHandler.class);

    DateCellDataHandler() {
    }

    @Override
    public boolean isMatchingCellType(StreamingCell cell) {
        return DateUtil.isADateFormat((int)cell.getNumericFormatIndex().shortValue(), (String)cell.getNumericFormat());
    }

    @Override
    public String handleCell(StreamingCell cell) {
        String rawContents = (String)cell.getRawContents();
        if (NumberUtils.isNumber((String)rawContents)) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date dateCellValue = cell.getDateCellValue();
                return dateFormat.format(dateCellValue);
            }
            catch (Exception e) {
                logger.warn("Tried to convert date " + rawContents + "but failed. skipping conversion");
            }
        }
        return rawContents;
    }
}

