/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.xlsx2csv;

import com.kenshoo.xlsx2csv.CellDataHandler;
import com.monitorjbl.xlsx.impl.StreamingCell;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NumberCellDataHandler
implements CellDataHandler {
    private static final Logger logger = LoggerFactory.getLogger(NumberCellDataHandler.class);
    private static final String DOT = ".";

    NumberCellDataHandler() {
    }

    @Override
    public boolean isMatchingCellType(StreamingCell cell) {
        return cell.getCellType() == 0 && ((String)cell.getRawContents()).contains(DOT);
    }

    @Override
    public String handleCell(StreamingCell cell) {
        return NumberToTextConverter.toText((double)cell.getNumericCellValue());
    }
}

