/*
 * Decompiled with CFR 0.152.
 */
package com.kenshoo.xlsx2csv;

import com.kenshoo.xlsx2csv.CellHandler;
import com.kenshoo.xlsx2csv.NoDataFoundException;
import com.kenshoo.xlsx2csv.NoSheetFoundException;
import com.monitorjbl.xlsx.StreamingReader;
import com.monitorjbl.xlsx.impl.StreamingCell;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XlsxToCsvConverter {
    private static final Logger logger = LoggerFactory.getLogger(XlsxToCsvConverter.class);
    private static final char QUOTE = '\"';
    private static final String COMMA = ",";
    private static final int DEFAULT_ROW_CACHE_SIZE = 10;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private final String delimiter;
    private final int rowCacheSize;
    private final int bufferSize;
    private final CellHandler cellHandler = new CellHandler();

    private XlsxToCsvConverter(String delimiter, int rowCacheSize, int bufferSize) {
        this.delimiter = delimiter;
        this.rowCacheSize = rowCacheSize;
        this.bufferSize = bufferSize;
    }

    public void convert(InputStream inputStream, FileOutputStream fileOutputStream) throws Exception {
        Optional<Iterator<Row>> optionalRowIterator = this.getRowIterator(inputStream);
        Iterator<Row> rowIterator = optionalRowIterator.orElseThrow(NoSheetFoundException::new);
        try {
            List<String> headers = this.getRowAsList(rowIterator.next());
            int rowSize = headers.size();
            try (CSVPrinter csvPrinter = this.createCSVPrinter(headers.toArray(new String[headers.size()]), this.delimiter, fileOutputStream);){
                this.writeRowsToFile(rowIterator, rowSize, csvPrinter);
            }
        }
        catch (NoSuchElementException e) {
            logger.error("File is empty, exiting converter");
            throw new NoDataFoundException();
        }
    }

    private void writeRowsToFile(Iterator<Row> rowIterator, int rowSize, CSVPrinter csvPrinter) throws IOException {
        while (rowIterator.hasNext()) {
            Row next = rowIterator.next();
            List<String> rowAsList = this.getRowAsList(next, rowSize);
            if (this.isLastLine(rowIterator.hasNext()) && !this.hasDataInLine(rowAsList)) continue;
            csvPrinter.printRecord(rowAsList);
        }
    }

    private boolean hasDataInLine(List<String> rowAsList) {
        return rowAsList.stream().anyMatch(StringUtils::isNotEmpty);
    }

    private boolean isLastLine(boolean hasNext) {
        return !hasNext;
    }

    private Optional<Iterator<Row>> getRowIterator(InputStream inputStream) {
        Workbook workbook = StreamingReader.builder().rowCacheSize(this.rowCacheSize).bufferSize(this.bufferSize).open(inputStream);
        return this.getFirstVisibleSheet(workbook).map(Sheet::rowIterator);
    }

    private Optional<Sheet> getFirstVisibleSheet(Workbook workbook) {
        OptionalInt firstIndex = IntStream.range(0, workbook.getNumberOfSheets()).filter(i -> !this.isSheetHidden(i, workbook)).findFirst();
        return firstIndex.isPresent() ? Optional.of(workbook.getSheetAt(firstIndex.getAsInt())) : Optional.empty();
    }

    private boolean isSheetHidden(int sheetInd, Workbook workbook) {
        return workbook.isSheetHidden(sheetInd) || workbook.isSheetVeryHidden(sheetInd);
    }

    private List<String> getRowAsList(Row row, int rowSize) {
        return IntStream.range(0, rowSize).mapToObj(index -> this.getCellValue(row, index)).collect(Collectors.toList());
    }

    private List<String> getRowAsList(Row row) {
        return this.getRowAsList(row, row.getLastCellNum());
    }

    private String getCellValue(Row row, int index) {
        Cell cell = row.getCell(index);
        return this.cellHandler.getDataFromCell((StreamingCell)cell);
    }

    private CSVPrinter createCSVPrinter(String[] headers, String delimiter, FileOutputStream outputStream) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, Charsets.UTF_8));
        CSVFormat format = CSVFormat.newFormat((char)delimiter.charAt(0)).withHeader(headers).withQuote('\"').withRecordSeparator(System.lineSeparator());
        return new CSVPrinter((Appendable)writer, format);
    }

    public static class Builder {
        private String delimiter = ",";
        private int rowCacheSize = 10;
        private int bufferSize = 1024;

        public Builder aConverter() {
            return new Builder();
        }

        public Builder withDelimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public Builder withRowCacheSize(int rowCacheSize) {
            this.rowCacheSize = rowCacheSize;
            return this;
        }

        public Builder withBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public XlsxToCsvConverter build() {
            return new XlsxToCsvConverter(this.delimiter, this.rowCacheSize, this.bufferSize);
        }
    }
}

