/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.client;

import com.kerb4j.client.SpnegoClient;
import com.kerb4j.client.SpnegoContext;
import com.kerb4j.common.util.SpnegoAuthScheme;
import com.kerb4j.common.util.SpnegoProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpnegoHttpURLConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoHttpURLConnection.class);
    private static final Lock LOCK = new ReentrantLock();
    private transient boolean connected = false;
    private transient String requestMethod = "GET";
    private final transient Map<String, List<String>> requestProperties = new LinkedHashMap<String, List<String>>();
    private final transient SpnegoClient spnegoClient;
    private transient boolean cntxtEstablished = false;
    private transient HttpURLConnection conn = null;
    private transient boolean reqCredDeleg = false;

    @Deprecated
    public SpnegoHttpURLConnection(final String loginModuleName) throws LoginException {
        this.spnegoClient = new SpnegoClient((Callable)new Callable<LoginContext>(){

            @Override
            public LoginContext call() throws Exception {
                try {
                    return new LoginContext(loginModuleName);
                }
                catch (LoginException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Deprecated
    public SpnegoHttpURLConnection(final String loginModuleName, final String username, final String password) throws LoginException {
        this.spnegoClient = new SpnegoClient((Callable)new Callable<LoginContext>(){

            @Override
            public LoginContext call() throws Exception {
                try {
                    return new LoginContext(loginModuleName, SpnegoProvider.getUsernameAndPasswordHandler((String)username, (String)password));
                }
                catch (LoginException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    public SpnegoHttpURLConnection(SpnegoClient spnegoClient) {
        this.spnegoClient = spnegoClient;
    }

    private void assertConnected() {
        if (!this.connected) {
            throw new IllegalStateException("Not connected.");
        }
    }

    private void assertNotConnected() {
        if (this.connected) {
            throw new IllegalStateException("Already connected.");
        }
    }

    public HttpURLConnection connect(URL url) throws GSSException, PrivilegedActionException, IOException {
        return this.connect(url, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection connect(URL url, ByteArrayOutputStream dooutput) throws GSSException, PrivilegedActionException, IOException {
        this.assertNotConnected();
        SpnegoContext context = this.spnegoClient.createContext(url);
        if (this.reqCredDeleg) {
            context.requestCredentialsDelegation();
        }
        try {
            this.conn = (HttpURLConnection)url.openConnection();
            this.connected = true;
            Set<String> keys = this.requestProperties.keySet();
            for (String key : keys) {
                for (String value : this.requestProperties.get(key)) {
                    this.conn.addRequestProperty(key, value);
                }
            }
            this.conn.setInstanceFollowRedirects(false);
            this.conn.setRequestMethod(this.requestMethod);
            this.conn.setRequestProperty("Authorization", context.createTokenAsAuthroizationHeader());
            if (null != dooutput && dooutput.size() > 0) {
                this.conn.setDoOutput(true);
                dooutput.writeTo(this.conn.getOutputStream());
            }
            this.conn.connect();
            SpnegoAuthScheme scheme = SpnegoProvider.getAuthScheme((String)this.conn.getHeaderField("WWW-Authenticate"));
            if (null == scheme) {
                LOGGER.trace("SpnegoProvider.getAuthScheme(...) returned null.");
            } else {
                byte[] data = scheme.getToken();
                if ("Negotiate".equalsIgnoreCase(scheme.getScheme())) {
                    LOCK.lock();
                    try {
                        context.processMutualAuthorization(data, 0, data.length);
                    }
                    finally {
                        LOCK.unlock();
                    }
                } else {
                    throw new UnsupportedOperationException("Scheme NOT Supported: " + scheme.getScheme());
                }
                this.cntxtEstablished = context.isEstablished();
            }
        }
        finally {
            this.dispose(context);
        }
        return this.conn;
    }

    private void dispose(SpnegoContext context) {
        if (null != context) {
            try {
                LOCK.lock();
                try {
                    context.close();
                }
                finally {
                    LOCK.unlock();
                }
            }
            catch (IOException gsse) {
                LOGGER.error("call to dispose context failed.", (Throwable)gsse);
            }
        }
    }

    public void disconnect() {
        this.dispose(null);
        this.requestProperties.clear();
        this.connected = false;
        if (null != this.conn) {
            this.conn.disconnect();
        }
    }

    public boolean isContextEstablished() {
        return this.cntxtEstablished;
    }

    private void assertKeyValue(String key, String value) {
        if (null == key || key.isEmpty()) {
            throw new IllegalArgumentException("key parameter is null or empty");
        }
        if (null == value) {
            throw new IllegalArgumentException("value parameter is null");
        }
    }

    public void addRequestProperty(String key, String value) {
        this.assertNotConnected();
        this.assertKeyValue(key, value);
        if (this.requestProperties.containsKey(key)) {
            List<String> val = this.requestProperties.get(key);
            val.add(value);
            this.requestProperties.put(key, val);
        } else {
            this.setRequestProperty(key, value);
        }
    }

    public void setRequestProperty(String key, String value) {
        this.assertNotConnected();
        this.assertKeyValue(key, value);
        this.requestProperties.put(key, Arrays.asList(value));
    }

    public InputStream getErrorStream() throws IOException {
        this.assertConnected();
        return this.conn.getInputStream();
    }

    public String getHeaderField(int index) {
        this.assertConnected();
        return this.conn.getHeaderField(index);
    }

    public String getHeaderField(String name) {
        this.assertConnected();
        return this.conn.getHeaderField(name);
    }

    public String getHeaderFieldKey(int index) {
        this.assertConnected();
        return this.conn.getHeaderFieldKey(index);
    }

    public InputStream getInputStream() throws IOException {
        this.assertConnected();
        return this.conn.getInputStream();
    }

    public OutputStream getOutputStream() throws IOException {
        this.assertConnected();
        return this.conn.getOutputStream();
    }

    public int getResponseCode() throws IOException {
        this.assertConnected();
        return this.conn.getResponseCode();
    }

    public String getResponseMessage() throws IOException {
        this.assertConnected();
        return this.conn.getResponseMessage();
    }

    public void requestCredDeleg(boolean requestDelegation) {
        this.assertNotConnected();
        this.reqCredDeleg = requestDelegation;
    }

    public void setRequestMethod(String method) {
        this.assertNotConnected();
        this.requestMethod = method;
    }
}

