/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.client;

import com.kerb4j.client.SpnegoContext;
import com.kerb4j.common.jaas.sun.Krb5LoginContext;
import com.kerb4j.common.util.JreVendor;
import com.kerb4j.common.util.LRUCache;
import com.kerb4j.common.util.SpnegoProvider;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.kerberos.KeyTab;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpnegoClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpnegoClient.class);
    private static final LRUCache<AbstractMap.SimpleEntry<String, String>, SpnegoClient> SPNEGO_CLIENT_CACHE = new LRUCache(1024);
    private final AtomicReference<SubjectTgtPair> subjectTgtPairReference = new AtomicReference();
    private final AtomicReference<Subject> eternalSubjectReference = new AtomicReference();
    private final Callable<Subject> subjectSupplier;
    private final Lock authenticateLock = new ReentrantLock();

    private SpnegoClient(final Callable<LoginContext> loginContextSupplier) {
        this.subjectSupplier = new Callable<Subject>(){

            @Override
            public Subject call() throws Exception {
                LoginContext loginContext = (LoginContext)loginContextSupplier.call();
                Subject subject = loginContext.getSubject();
                if (null == subject) {
                    try {
                        loginContext.login();
                        subject = loginContext.getSubject();
                    }
                    catch (LoginException e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }
                return subject;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetCache() {
        LRUCache<AbstractMap.SimpleEntry<String, String>, SpnegoClient> lRUCache = SPNEGO_CLIENT_CACHE;
        synchronized (lRUCache) {
            SPNEGO_CLIENT_CACHE.clear();
        }
    }

    public static SpnegoClient loginWithUsernamePassword(String username, String password) {
        return SpnegoClient.loginWithUsernamePassword(username, password, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpnegoClient loginWithUsernamePassword(String username, String password, boolean useCache) {
        SpnegoClient spnegoClient;
        if (!useCache) {
            return SpnegoClient.loginWithUsernamePasswordImpl(username, password);
        }
        AbstractMap.SimpleEntry<String, String> entry = new AbstractMap.SimpleEntry<String, String>(username, password);
        LRUCache<AbstractMap.SimpleEntry<String, String>, SpnegoClient> lRUCache = SPNEGO_CLIENT_CACHE;
        synchronized (lRUCache) {
            spnegoClient = (SpnegoClient)SPNEGO_CLIENT_CACHE.get(entry);
            if (null == spnegoClient) {
                spnegoClient = SpnegoClient.loginWithUsernamePasswordImpl(username, password);
                SPNEGO_CLIENT_CACHE.put(entry, spnegoClient);
            }
        }
        return spnegoClient;
    }

    private static SpnegoClient loginWithUsernamePasswordImpl(final String username, final String password) {
        return new SpnegoClient(new Callable<LoginContext>(){

            @Override
            public LoginContext call() throws Exception {
                return Krb5LoginContext.loginWithUsernameAndPassword(username, password);
            }
        });
    }

    public static SpnegoClient loginWithKeyTab(String principal, String keyTabLocation) {
        return SpnegoClient.loginWithKeyTab(principal, keyTabLocation, false);
    }

    public static SpnegoClient loginWithKeyTab(final String principal, final String keyTabLocation, final boolean acceptOnly) {
        return new SpnegoClient(new Callable<LoginContext>(){

            @Override
            public LoginContext call() throws Exception {
                return Krb5LoginContext.loginWithKeyTab(principal, keyTabLocation, acceptOnly);
            }
        });
    }

    public static SpnegoClient loginWithTicketCache(final String principal) {
        return new SpnegoClient(new Callable<LoginContext>(){

            @Override
            public LoginContext call() throws Exception {
                return Krb5LoginContext.loginWithTicketCache(principal);
            }
        });
    }

    public static SpnegoClient loginWithContext(final LoginContext loginContext) throws LoginException {
        return SpnegoClient.loginWithContextSupplier(new Callable<LoginContext>(){

            @Override
            public LoginContext call() throws Exception {
                return loginContext;
            }
        });
    }

    public static SpnegoClient loginWithContextSupplier(Callable<LoginContext> loginContextSupplier) throws LoginException {
        return new SpnegoClient(loginContextSupplier);
    }

    public Subject getSubject() {
        Subject eternalSubject = this.eternalSubjectReference.get();
        if (null != eternalSubject) {
            return eternalSubject;
        }
        SubjectTgtPair subjectTgtPair = this.subjectTgtPairReference.get();
        if (null == subjectTgtPair || subjectTgtPair.isExpired()) {
            this.authenticateLock.lock();
            try {
                eternalSubject = this.eternalSubjectReference.get();
                if (null != eternalSubject) {
                    Subject subject = eternalSubject;
                    return subject;
                }
                subjectTgtPair = this.subjectTgtPairReference.get();
                if (null == subjectTgtPair || subjectTgtPair.isExpired()) {
                    Subject subject = this.subjectSupplier.call();
                    for (KerberosTicket ticket : subject.getPrivateCredentials(KerberosTicket.class)) {
                        if (!ticket.getServer().getName().startsWith("krbtgt")) continue;
                        this.subjectTgtPairReference.set(new SubjectTgtPair(ticket, subject));
                        break;
                    }
                    if (null == (subjectTgtPair = this.subjectTgtPairReference.get())) {
                        this.eternalSubjectReference.set(subject);
                        Subject subject2 = subject;
                        return subject2;
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.authenticateLock.unlock();
            }
        }
        return subjectTgtPair.subject;
    }

    public KerberosKey[] getKerberosKeys() {
        Set<KerberosKey> kerberosKeys = this.getSubject().getPrivateCredentials(KerberosKey.class);
        if (!kerberosKeys.isEmpty()) {
            return new ArrayList<KerberosKey>(kerberosKeys).toArray(new KerberosKey[kerberosKeys.size()]);
        }
        Set<KerberosPrincipal> kerberosPrincipals = this.getSubject().getPrincipals(KerberosPrincipal.class);
        for (KerberosPrincipal kerberosPrincipal : kerberosPrincipals) {
            Set<KeyTab> keyTabs = this.getSubject().getPrivateCredentials(KeyTab.class);
            for (KeyTab keyTab : keyTabs) {
                KerberosKey[] keys = keyTab.getKeys(kerberosPrincipal);
                if (null == keys || keys.length <= 0) continue;
                return keys;
            }
        }
        return null;
    }

    public SpnegoContext createContext(URL url) throws PrivilegedActionException, GSSException {
        return new SpnegoContext(this, this.getGSSContext(url));
    }

    public SpnegoContext createContextForSPN(String spn) throws PrivilegedActionException, GSSException, MalformedURLException {
        return new SpnegoContext(this, this.getGSSContextForSPN(spn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAuthroizationHeader(URL url) throws PrivilegedActionException, GSSException, IOException {
        try (SpnegoContext context = this.createContext(url);){
            String string = context.createTokenAsAuthroizationHeader();
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createAuthroizationHeaderForSPN(String spn) throws PrivilegedActionException, GSSException, IOException {
        try (SpnegoContext contextForSPN = this.createContextForSPN(spn);){
            String string = contextForSPN.createTokenAsAuthroizationHeader();
            return string;
        }
    }

    public SpnegoContext createAcceptContext() throws PrivilegedActionException {
        return new SpnegoContext(this, Subject.doAs(this.getSubject(), new PrivilegedExceptionAction<GSSContext>(){

            @Override
            public GSSContext run() throws Exception {
                int credentialLifetime = JreVendor.IS_IBM_JVM ? Integer.MAX_VALUE : 0;
                GSSCredential credential = SpnegoProvider.GSS_MANAGER.createCredential(null, credentialLifetime, SpnegoProvider.SUPPORTED_OIDS, 2);
                return SpnegoProvider.GSS_MANAGER.createContext(credential);
            }
        }));
    }

    private GSSContext getGSSContextForSPN(String spn) throws GSSException, PrivilegedActionException {
        return this.getGSSContext(SpnegoProvider.createGSSNameForSPN(spn));
    }

    private GSSContext getGSSContext(URL url) throws GSSException, PrivilegedActionException {
        return this.getGSSContext(SpnegoProvider.getServerName(url));
    }

    private GSSContext getGSSContext(final GSSName gssName) throws GSSException, PrivilegedActionException {
        try {
            Thread.sleep(31L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Subject.doAs(this.getSubject(), new PrivilegedExceptionAction<GSSContext>(){

            @Override
            public GSSContext run() throws Exception {
                GSSCredential credential = SpnegoProvider.GSS_MANAGER.createCredential(null, 0, SpnegoProvider.SUPPORTED_OIDS, 1);
                GSSContext context = SpnegoProvider.GSS_MANAGER.createContext(gssName, SpnegoProvider.SPNEGO_OID, credential, 0);
                context.requestMutualAuth(true);
                context.requestConf(true);
                context.requestInteg(true);
                context.requestReplayDet(true);
                context.requestSequenceDet(true);
                return context;
            }
        });
    }

    private static class SubjectTgtPair {
        private final KerberosTicket tgt;
        private final Subject subject;

        private SubjectTgtPair(KerberosTicket tgt, Subject subject) {
            this.tgt = tgt;
            this.subject = subject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isExpired() {
            try {
                KerberosTicket kerberosTicket = this.tgt;
                synchronized (kerberosTicket) {
                    return this.tgt.getEndTime().before(new Date());
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to get Kerberos ticket end time", (Throwable)e);
                return true;
            }
        }
    }
}

