/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.marshall.pac;

import com.kerb4j.server.marshall.Kerb4JException;
import com.kerb4j.server.marshall.pac.PacDataInputStream;
import com.kerb4j.server.marshall.pac.PacUnicodeString;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PacDelegationInfo {
    private String proxyTarget;
    private List<String> transitedServices;

    public PacDelegationInfo(byte[] data) throws Kerb4JException {
        try {
            PacDataInputStream pacStream = new PacDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
            pacStream.skipBytes(20);
            PacUnicodeString proxyTargetString = pacStream.readUnicodeString();
            int transitedListSize = pacStream.readInt();
            PacUnicodeString[] transitedServiceStrings = new PacUnicodeString[transitedListSize];
            pacStream.skipBytes(4);
            this.proxyTarget = proxyTargetString.check(pacStream.readString());
            int listSize = pacStream.readInt();
            if (transitedListSize != listSize) {
                throw new Kerb4JException("pac.delegationinfo.transitedlist.sizenotmatching");
            }
            for (int i = 0; i < listSize; ++i) {
                transitedServiceStrings[i] = pacStream.readUnicodeString();
            }
            String[] transitedServices = new String[transitedListSize];
            for (int i = 0; i < transitedListSize; ++i) {
                transitedServices[i] = transitedServiceStrings[i].check(pacStream.readString());
            }
            this.transitedServices = Collections.unmodifiableList(Arrays.asList(transitedServices));
        }
        catch (IOException e) {
            throw new Kerb4JException("pac.delegationinfo.malformed", null, e);
        }
    }

    public String getProxyTarget() {
        return this.proxyTarget;
    }

    public List<String> getTransitedServices() {
        return this.transitedServices;
    }
}

