/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.marshall.spnego;

import com.kerb4j.server.marshall.Kerb4JException;
import com.kerb4j.server.marshall.pac.Pac;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import javax.security.auth.kerberos.KerberosKey;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1ObjectIdentifier;
import org.apache.kerby.kerberos.kerb.KrbCodec;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.EncryptionHandler;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationData;
import org.apache.kerby.kerberos.kerb.type.ad.AuthorizationDataEntry;
import org.apache.kerby.kerberos.kerb.type.ap.ApReq;
import org.apache.kerby.kerberos.kerb.type.base.EncryptedData;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;
import org.apache.kerby.kerberos.kerb.type.ticket.EncTicketPart;

public class SpnegoKerberosMechToken {
    private ApReq apRequest;

    public SpnegoKerberosMechToken(byte[] token) throws Kerb4JException {
        if (token.length <= 0) {
            throw new Kerb4JException("kerberos.token.empty", null, null);
        }
        try {
            Asn1ParseResult asn1ParseResult = Asn1Parser.parse((ByteBuffer)ByteBuffer.wrap(token));
            Asn1ParseResult item1 = (Asn1ParseResult)((Asn1Container)asn1ParseResult).getChildren().get(0);
            Asn1ObjectIdentifier asn1ObjectIdentifier = new Asn1ObjectIdentifier();
            asn1ObjectIdentifier.decode(item1);
            if (!((String)asn1ObjectIdentifier.getValue()).equals("1.2.840.113554.1.2.2")) {
                throw new Kerb4JException("kerberos.token.malformed", null, null);
            }
            Asn1ParseResult item2 = (Asn1ParseResult)((Asn1Container)asn1ParseResult).getChildren().get(1);
            int read = 0;
            int readLow = item2.getBodyBuffer().get(item2.getOffset()) & 0xFF;
            int readHigh = item2.getBodyBuffer().get(item2.getOffset() + 1) & 0xFF;
            read = (readHigh << 8) + readLow;
            if (read != 1) {
                throw new Kerb4JException("kerberos.token.malformed", null, null);
            }
            Asn1ParseResult item3 = (Asn1ParseResult)((Asn1Container)asn1ParseResult).getChildren().get(2);
            ApReq apReq = new ApReq();
            apReq.decode(item3);
            this.apRequest = apReq;
        }
        catch (IOException e) {
            throw new Kerb4JException("kerberos.token.malformed", null, e);
        }
    }

    public ApReq getApRequest() {
        return this.apRequest;
    }

    public KerberosKey getKerberosKey(EncryptionType eType, KerberosKey[] kerberosKeys) throws KrbException {
        for (KerberosKey kerberosKey : kerberosKeys) {
            if (kerberosKey.getKeyType() != eType.getValue()) continue;
            return kerberosKey;
        }
        return null;
    }

    public EncTicketPart getEncryptedTicketPart(byte[] cipher, KerberosKey kerberosKey) throws KrbException {
        byte[] decrypt = EncryptionHandler.getEncHandler((int)kerberosKey.getKeyType()).decrypt(cipher, kerberosKey.getEncoded(), KeyUsage.KDC_REP_TICKET.getValue());
        return (EncTicketPart)KrbCodec.decode((byte[])decrypt, EncTicketPart.class);
    }

    public Pac getPac(KerberosKey[] kerberosKeys) throws KrbException, Kerb4JException {
        EncryptedData encryptedData = this.getApRequest().getTicket().getEncryptedEncPart();
        KerberosKey kerberosKey = this.getKerberosKey(encryptedData.getEType(), kerberosKeys);
        EncTicketPart tgsRep = this.getEncryptedTicketPart(encryptedData.getCipher(), kerberosKey);
        AuthorizationData authorizationData = tgsRep.getAuthorizationData();
        if (null == authorizationData) {
            return null;
        }
        List authorizationDataEntries = authorizationData.getElements();
        return this.extractPac(authorizationDataEntries, kerberosKey);
    }

    private Pac extractPac(List<AuthorizationDataEntry> authorizationDataEntries, KerberosKey kerberosKey) throws Kerb4JException {
        block4: for (AuthorizationDataEntry authorizationDataEntry : authorizationDataEntries) {
            switch (authorizationDataEntry.getAuthzType()) {
                case AD_IF_RELEVANT: {
                    Pac pac = this.extractPac(((AuthorizationData)authorizationDataEntry.getAuthzDataAs(AuthorizationData.class)).getElements(), kerberosKey);
                    if (null == pac) continue block4;
                    return pac;
                }
                case AD_WIN2K_PAC: {
                    return new Pac(authorizationDataEntry.getAuthzData(), kerberosKey);
                }
            }
        }
        return null;
    }
}

