/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server;

import java.util.LinkedHashMap;

public class SpnegoTokenFixer {
    private final byte[] token;
    private int pos = 0;

    private SpnegoTokenFixer(byte[] token) {
        this.token = token;
    }

    public static void fix(byte[] token) {
        SpnegoTokenFixer fixer = new SpnegoTokenFixer(token);
        fixer.fix();
    }

    private void fix() {
        if (!this.tag(96)) {
            return;
        }
        if (!this.length()) {
            return;
        }
        if (!this.oid("1.3.6.1.5.5.2")) {
            return;
        }
        if (!this.tag(160)) {
            return;
        }
        if (!this.length()) {
            return;
        }
        if (!this.tag(48)) {
            return;
        }
        if (!this.length()) {
            return;
        }
        if (!this.tag(160)) {
            return;
        }
        this.lengthAsInt();
        if (!this.tag(48)) {
            return;
        }
        int mechTypesLen = this.lengthAsInt();
        int mechTypesStart = this.pos;
        LinkedHashMap<String, int[]> mechTypeEntries = new LinkedHashMap<String, int[]>();
        while (this.pos < mechTypesStart + mechTypesLen) {
            int[] value = new int[2];
            value[0] = this.pos;
            String key = this.oidAsString();
            value[1] = this.pos - value[0];
            mechTypeEntries.put(key, value);
        }
        byte[] replacement = new byte[mechTypesLen];
        int replacementPos = 0;
        int[] first = (int[])mechTypeEntries.remove("1.2.840.113554.1.2.2");
        if (first != null) {
            System.arraycopy(this.token, first[0], replacement, replacementPos, first[1]);
            replacementPos += first[1];
        }
        for (int[] markers : mechTypeEntries.values()) {
            System.arraycopy(this.token, markers[0], replacement, replacementPos, markers[1]);
            replacementPos += markers[1];
        }
        System.arraycopy(replacement, 0, this.token, mechTypesStart, mechTypesLen);
    }

    private boolean tag(int expected) {
        return (this.token[this.pos++] & 0xFF) == expected;
    }

    private boolean length() {
        int len = this.lengthAsInt();
        return this.pos + len == this.token.length;
    }

    private int lengthAsInt() {
        int len;
        if ((len = this.token[this.pos++] & 0xFF) > 127) {
            int bytes = len - 128;
            len = 0;
            for (int i = 0; i < bytes; ++i) {
                len <<= 8;
                len += this.token[this.pos++] & 0xFF;
            }
        }
        return len;
    }

    private boolean oid(String expected) {
        return expected.equals(this.oidAsString());
    }

    private String oidAsString() {
        if (!this.tag(6)) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int len = this.lengthAsInt();
        int v = this.token[this.pos++] & 0xFF;
        int c2 = v % 40;
        int c1 = (v - c2) / 40;
        result.append(c1);
        result.append('.');
        result.append(c2);
        int c = 0;
        boolean write = false;
        for (int i = 1; i < len; ++i) {
            int b;
            if ((b = this.token[this.pos++] & 0xFF) > 127) {
                b -= 128;
            } else {
                write = true;
            }
            c <<= 7;
            c += b;
            if (!write) continue;
            result.append('.');
            result.append(c);
            c = 0;
            write = false;
        }
        return result.toString();
    }
}

