/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.ldap;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class KeepAliveLdapConnection {
    public static final int DEFAULT_TIMEOUT = 600000;
    private static Map<String, KeepAliveLdapConnection> instances = new Hashtable<String, KeepAliveLdapConnection>();
    private Hashtable<Object, Object> environnement = new Hashtable();
    private int timeout;
    private Subject subject;
    private DirContext context;
    private Thread closing;

    protected KeepAliveLdapConnection() {
        this.environnement.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        this.environnement.put("java.naming.security.authentication", "GSSAPI");
        this.environnement.put("javax.security.auth.useSubjectCredsOnly", "false");
        try {
            LoginContext lc = new LoginContext(System.getProperty("org.jaaslounge.sso.jaas.config"));
            lc.login();
            this.subject = lc.getSubject();
        }
        catch (LoginException e) {
            this.subject = null;
        }
    }

    public static synchronized KeepAliveLdapConnection getConnection(String providerUrl, int timeout, Map<String, Object> environnement) {
        KeepAliveLdapConnection instance = instances.get(providerUrl);
        if (instance == null) {
            instance = new KeepAliveLdapConnection();
            instance.environnement.put("java.naming.provider.url", providerUrl);
            if (environnement != null) {
                instance.environnement.putAll(environnement);
            }
            instances.put(providerUrl, instance);
        }
        instance.timeout = timeout;
        return instance;
    }

    public synchronized NamingEnumeration<SearchResult> search(final String base, final String filter, final SearchControls controls) throws NamingException {
        NamingEnumeration<SearchResult> result = null;
        if (this.context == null) {
            this.context = new InitialDirContext(this.environnement);
        }
        if (this.closing != null && this.closing.isAlive()) {
            this.closing.interrupt();
        }
        this.closing = new Closure();
        this.closing.start();
        try {
            result = Subject.doAs(this.subject, new PrivilegedExceptionAction<NamingEnumeration<SearchResult>>(){

                @Override
                public NamingEnumeration<SearchResult> run() throws NamingException {
                    return KeepAliveLdapConnection.this.context.search(base, filter, controls);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (NamingException)e.getCause();
        }
        return result;
    }

    private synchronized void disconnect() {
        try {
            this.context.close();
        }
        catch (NamingException namingException) {
        }
        finally {
            this.context = null;
        }
    }

    private class Closure
    extends Thread {
        private Closure() {
        }

        @Override
        public void run() {
            try {
                Closure.sleep(KeepAliveLdapConnection.this.timeout);
                KeepAliveLdapConnection.this.disconnect();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

