/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.ldap;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class LDAPCallbackHandler
implements CallbackHandler {
    private String _sUsername = null;
    private String _sPasswd = null;

    public LDAPCallbackHandler() {
    }

    public LDAPCallbackHandler(String username, String passwd) {
        this._sUsername = username;
        this._sPasswd = passwd;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback namecallback = (NameCallback)callbacks[i];
                if (this._sUsername == null) {
                    System.out.print(namecallback.getPrompt());
                    namecallback.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                    continue;
                }
                namecallback.setName(this._sUsername);
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback passwordcallback = (PasswordCallback)callbacks[i];
                if (this._sPasswd == null) {
                    System.out.print(passwordcallback.getPrompt());
                    passwordcallback.setPassword(new BufferedReader(new InputStreamReader(System.in)).readLine().toCharArray());
                    continue;
                }
                passwordcallback.setPassword(this._sPasswd.toCharArray());
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i]);
        }
    }
}

