/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.ldap;

import com.kerb4j.server.ldap.LDAPCallbackHandler;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class LDAPReader
implements PrivilegedAction {
    private DirContext _cDirContext = null;
    private List _cUserGroups = new ArrayList();
    private Map _cMap = null;
    private boolean _bDebug = false;
    private String _sUser = null;
    private char[] _sPasswd = null;
    private String _sLDAPServerURL = null;
    private String _sLDAPSuperUserContext = null;
    private String _sLDAPInitialContextFactory = null;
    private String _sLDAPSearchFilter = null;
    private boolean _sLDAPTruncateMemberOf = false;
    private String _sLDAPGroupSearch = null;
    private String _sLDAPClassName = null;
    private String _sLDAPUserSearch = null;

    public LDAPReader(Map opts, boolean isDebug, String sUser, char[] sPasswd) throws Exception {
        if (opts == null || sUser == null || sPasswd == null) {
            throw new Exception("LDAPReader(Map opts,boolean isDebug,CallbackHandler callback,String sUser,char[] sPasswd): Parameter null");
        }
        this._bDebug = isDebug;
        this._cMap = opts;
        this._sUser = sUser;
        this._sPasswd = sPasswd;
        this.init();
    }

    public Object run() {
        this.LDAPConnect();
        return null;
    }

    public void LDAPConnect() {
        Hashtable<String, String> env = new Hashtable<String, String>(11);
        env.put("java.naming.provider.url", this._sLDAPServerURL);
        env.put("java.naming.factory.initial", this._sLDAPInitialContextFactory);
        env.put("java.naming.security.authentication", "GSSAPI");
        env.put("javax.security.sasl.qop", "auth");
        try {
            this._cDirContext = new InitialDirContext(env);
            if (this._bDebug) {
                System.out.println("[" + this.getClass().getName() + "] " + this._cDirContext.getAttributes(this._sLDAPServerURL, new String[]{"supportedSASLMechanisms"}).clone().toString());
            }
            SearchControls searchCtls = new SearchControls();
            searchCtls.setSearchScope(2);
            String searchFilter = this._sLDAPSearchFilter != null ? this._sLDAPSearchFilter : "(&(objectClass=user)(CN=%s*))";
            searchFilter = this.ReplaceSearchParameter(searchFilter, this._sUser);
            if (this._bDebug) {
                System.out.println("[" + this.getClass().getName() + "]: searchFilter: " + searchFilter);
            }
            String[] returnedAtts = new String[]{"memberOf"};
            searchCtls.setReturningAttributes(returnedAtts);
            NamingEnumeration<SearchResult> answer = this._cDirContext.search(this._sLDAPSuperUserContext, searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                Attributes attrs;
                SearchResult sr = answer.next();
                if (this._bDebug) {
                    System.out.println("[" + this.getClass().getName() + "] " + sr.getName());
                }
                if ((attrs = sr.getAttributes()) == null) continue;
                try {
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMore()) {
                        Attribute attr = ae.next();
                        if (this._bDebug) {
                            System.out.println("[" + this.getClass().getName() + "]: Attribute: " + attr.getID());
                        }
                        NamingEnumeration<?> e = attr.getAll();
                        while (e.hasMoreElements()) {
                            int cnloc;
                            String strElement = e.nextElement().toString();
                            if (this._sLDAPTruncateMemberOf && (cnloc = strElement.indexOf("CN=")) != -1) {
                                int commaloc;
                                int startloc = cnloc + 3;
                                int stoploc = commaloc = strElement.indexOf(",", cnloc + 3);
                                strElement = strElement.substring(startloc, stoploc);
                            }
                            if (this._bDebug) {
                                System.out.println("[" + this.getClass().getName() + "]: " + strElement);
                            }
                            this._cUserGroups.add(strElement);
                        }
                    }
                }
                catch (NamingException e) {
                    System.out.println("[" + this.getClass().getName() + "]: Problem listing membership: " + e);
                }
            }
            this._cDirContext.close();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    private String ReplaceSearchParameter(String searchFilter, String user) {
        StringBuffer retbuf = new StringBuffer(searchFilter);
        int userloc = retbuf.indexOf("%s");
        if (userloc != -1) {
            while (userloc != -1) {
                retbuf.delete(userloc, userloc + 2);
                retbuf.insert(userloc, user);
                userloc = retbuf.indexOf("%s");
            }
        }
        return retbuf.toString();
    }

    private void init() throws Exception {
        this._sLDAPServerURL = (String)this._cMap.get("LDAPServerURL");
        this._sLDAPSuperUserContext = (String)this._cMap.get("LDAPSuperUserContext");
        this._sLDAPInitialContextFactory = (String)this._cMap.get("LDAPInitialContextFactory");
        this._sLDAPSearchFilter = (String)this._cMap.get("LDAPSearchFilter");
        String truncate = (String)this._cMap.get("LDAPTruncateMemberOf");
        this._sLDAPTruncateMemberOf = truncate == null ? false : truncate.equalsIgnoreCase("yes") || truncate.equalsIgnoreCase("1") || truncate.equalsIgnoreCase("on") || truncate.equalsIgnoreCase("true");
        if (this._sLDAPServerURL == null) {
            throw new Exception("Missing Parameter [LDAPServerURL]");
        }
        if (this._sLDAPSuperUserContext == null) {
            throw new Exception("Missing Parameter [LDAPSuperUserContext]");
        }
        if (this._sLDAPInitialContextFactory == null) {
            throw new Exception("Missing Parameter [LDAPInitialContextFactory]");
        }
        if (this._bDebug) {
            System.out.println("[" + this.getClass().getName() + "]: LDAPServerURL=" + this._sLDAPServerURL);
            System.out.println("[" + this.getClass().getName() + "]: LDAPSuperUserContext=" + this._sLDAPSuperUserContext);
            System.out.println("[" + this.getClass().getName() + "]: LDAPInitialContextFactory=" + this._sLDAPInitialContextFactory);
            System.out.println("[" + this.getClass().getName() + "]: LDAPSearchFilter=" + this._sLDAPSearchFilter);
            System.out.println("[" + this.getClass().getName() + "]: LDAPTruncateMemberOf=" + this._sLDAPTruncateMemberOf);
        }
    }

    public void connect() throws Exception {
        if (this._bDebug) {
            System.out.println("[" + this.getClass().getName() + "] sun.security.krb5.debug=true");
            System.setProperty("sun.security.krb5.debug", "true");
        }
        LoginContext context = null;
        try {
            if (this._bDebug) {
                System.out.println("[" + this.getClass().getName() + "]: Kerberos Authentication start");
                System.out.println("[" + this.getClass().getName() + "]: java.security.auth.login.config = " + System.getProperty("java.security.auth.login.config"));
            }
            context = new LoginContext("Kerberos", new LDAPCallbackHandler(this._sUser, new String(this._sPasswd)));
            context.login();
            if (this._bDebug) {
                System.out.println("[" + this.getClass().getName() + "]: Kerberos Authentication succesful");
            }
            Subject.doAs(context.getSubject(), this);
            if (this._bDebug) {
                System.out.println("[" + this.getClass().getName() + "]: LDAP Authentication succesful");
            }
        }
        catch (LoginException ex) {
            if (this._bDebug) {
                System.out.println("[" + this.getClass().getName() + "]: Kerberos or LDAP Authentication failed");
            }
            throw new Exception("LDAPReader()::connect: " + ex.getMessage());
        }
    }

    public List getMemberGroups() {
        return this._cUserGroups;
    }
}

