/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.marshall.pac;

import com.kerb4j.server.marshall.Kerb4JException;
import com.kerb4j.server.marshall.pac.PacCredentialType;
import com.kerb4j.server.marshall.pac.PacDataInputStream;
import com.kerb4j.server.marshall.pac.PacDelegationInfo;
import com.kerb4j.server.marshall.pac.PacLogonInfo;
import com.kerb4j.server.marshall.pac.PacSignature;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.CheckSumHandler;
import org.apache.kerby.kerberos.kerb.type.base.CheckSumType;
import org.apache.kerby.kerberos.kerb.type.base.KeyUsage;

public class Pac {
    private PacLogonInfo logonInfo;
    private PacCredentialType credentialType;
    private List<PacDelegationInfo> delegationInfos = new ArrayList<PacDelegationInfo>();
    private List<PacDelegationInfo> delegationInfosReadOnly = Collections.unmodifiableList(this.delegationInfos);
    private PacSignature serverSignature;
    private PacSignature kdcSignature;

    public Pac(byte[] data, Key key) throws Kerb4JException {
        byte[] checksum;
        byte[] checksumData = (byte[])data.clone();
        try {
            PacDataInputStream pacStream = new PacDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
            if (data.length <= 8) {
                throw new Kerb4JException("pac.token.empty", null, null);
            }
            int bufferCount = pacStream.readInt();
            int version = pacStream.readInt();
            if (version != 0) {
                Object[] args = new Object[]{version};
                throw new Kerb4JException("pac.version.invalid", args, null);
            }
            block11: for (int bufferIndex = 0; bufferIndex < bufferCount; ++bufferIndex) {
                int sigTypeLength = 4;
                int bufferType = pacStream.readInt();
                int bufferSize = pacStream.readInt();
                long bufferOffset = pacStream.readLong();
                byte[] bufferData = new byte[bufferSize];
                System.arraycopy(data, (int)bufferOffset, bufferData, 0, bufferSize);
                switch (bufferType) {
                    case 1: {
                        this.logonInfo = new PacLogonInfo(bufferData);
                        continue block11;
                    }
                    case 2: {
                        this.credentialType = new PacCredentialType(bufferData);
                        continue block11;
                    }
                    case 11: {
                        this.delegationInfos.add(new PacDelegationInfo(bufferData));
                        continue block11;
                    }
                    case 6: {
                        int i;
                        this.serverSignature = new PacSignature(bufferData);
                        for (i = 0; i < bufferSize - 4; ++i) {
                            checksumData[(int)bufferOffset + 4 + i] = 0;
                        }
                        continue block11;
                    }
                    case 7: {
                        int i;
                        this.kdcSignature = new PacSignature(bufferData);
                        for (i = 0; i < bufferSize - 4; ++i) {
                            checksumData[(int)bufferOffset + 4 + i] = 0;
                        }
                        continue block11;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new Kerb4JException("pac.token.malformed", null, e);
        }
        try {
            checksum = CheckSumHandler.getCheckSumHandler((CheckSumType)CheckSumType.fromValue((Integer)this.serverSignature.getType())).checksumWithKey(checksumData, key.getEncoded(), KeyUsage.APP_DATA_CKSUM.getValue());
        }
        catch (KrbException e) {
            throw new Kerb4JException("pac.check.fail", null, e);
        }
        if (!Arrays.equals(this.serverSignature.getChecksum(), checksum)) {
            throw new Kerb4JException("pac.signature.invalid", null, null);
        }
    }

    public PacLogonInfo getLogonInfo() {
        return this.logonInfo;
    }

    public PacCredentialType getCredentialType() {
        return this.credentialType;
    }

    public PacSignature getServerSignature() {
        return this.serverSignature;
    }

    public PacSignature getKdcSignature() {
        return this.kdcSignature;
    }

    public List<PacDelegationInfo> getDelegationInfos() {
        return this.delegationInfosReadOnly;
    }
}

