/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.marshall.pac;

import com.kerb4j.server.marshall.Kerb4JException;

public class PacSid {
    private static final String FORMAT = "%1$02x";
    private byte revision;
    private byte subCount;
    private byte[] authority;
    private byte[] subs;

    public PacSid(byte[] bytes) throws Kerb4JException {
        if (bytes.length < 8 || (bytes.length - 8) % 4 != 0 || (bytes.length - 8) / 4 != bytes[1]) {
            throw new Kerb4JException("pac.sid.malformed.size", null, null);
        }
        this.revision = bytes[0];
        this.subCount = bytes[1];
        this.authority = new byte[6];
        System.arraycopy(bytes, 2, this.authority, 0, 6);
        this.subs = new byte[bytes.length - 8];
        System.arraycopy(bytes, 8, this.subs, 0, bytes.length - 8);
    }

    public PacSid(PacSid sid) {
        this.revision = sid.revision;
        this.subCount = sid.subCount;
        this.authority = new byte[6];
        System.arraycopy(sid.authority, 0, this.authority, 0, 6);
        this.subs = new byte[sid.subs.length];
        System.arraycopy(sid.subs, 0, this.subs, 0, sid.subs.length);
    }

    public static String convertSidToStringSid(byte[] sid) {
        int i;
        if (sid[0] != 1) {
            throw new IllegalArgumentException("SID revision must be 1");
        }
        StringBuilder stringSidBuilder = new StringBuilder("S-1-");
        int subAuthorityCount = sid[1] & 0xFF;
        long identifierAuthority = 0L;
        int offset = 2;
        int size = 6;
        for (i = 0; i < size; ++i) {
            identifierAuthority |= (long)(sid[offset + i] & 0xFF) << 8 * (size - 1 - i);
        }
        if ((double)identifierAuthority < Math.pow(2.0, 32.0)) {
            stringSidBuilder.append(Long.toString(identifierAuthority));
        } else {
            stringSidBuilder.append("0x").append(Long.toHexString(identifierAuthority).toUpperCase());
        }
        offset = 8;
        size = 4;
        i = 0;
        while (i < subAuthorityCount) {
            long subAuthority = 0L;
            for (int j = 0; j < size; ++j) {
                subAuthority |= (long)(sid[offset + j] & 0xFF) << 8 * j;
            }
            stringSidBuilder.append("-").append(subAuthority);
            ++i;
            offset += size;
        }
        return stringSidBuilder.toString();
    }

    public static String toString(byte[] bytes) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            int unsignedByte = bytes[i] & 0xFF;
            builder.append("\\").append(String.format(FORMAT, unsignedByte));
        }
        return builder.toString();
    }

    public static PacSid createFromSubs(byte[] bytes) throws Kerb4JException {
        if (bytes.length % 4 != 0) {
            Object[] args = new Object[]{bytes.length};
            throw new Kerb4JException("pac.subauthority.malformed.size", args, null);
        }
        byte[] sidBytes = new byte[8 + bytes.length];
        sidBytes[0] = 1;
        sidBytes[1] = (byte)(bytes.length / 4);
        System.arraycopy(new byte[]{0, 0, 0, 0, 0, 5}, 0, sidBytes, 2, 6);
        System.arraycopy(bytes, 0, sidBytes, 8, bytes.length);
        return new PacSid(sidBytes);
    }

    public static PacSid append(PacSid sid1, PacSid sid2) {
        PacSid sid = new PacSid(sid1);
        sid.subCount = (byte)(sid.subCount + sid2.subCount);
        sid.subs = new byte[sid.subCount * 4];
        System.arraycopy(sid1.subs, 0, sid.subs, 0, sid1.subs.length);
        System.arraycopy(sid2.subs, 0, sid.subs, sid1.subs.length, sid2.subs.length);
        return sid;
    }

    public String toHumanReadableString() {
        return PacSid.convertSidToStringSid(this.getBytes());
    }

    public String toString() {
        int unsignedByte;
        int i;
        StringBuilder builder = new StringBuilder();
        builder.append("\\").append(String.format(FORMAT, this.revision & 0xFF));
        builder.append("\\").append(String.format(FORMAT, this.subCount & 0xFF));
        for (i = 0; i < this.authority.length; ++i) {
            unsignedByte = this.authority[i] & 0xFF;
            builder.append("\\").append(String.format(FORMAT, unsignedByte));
        }
        for (i = 0; i < this.subs.length; ++i) {
            unsignedByte = this.subs[i] & 0xFF;
            builder.append("\\").append(String.format(FORMAT, unsignedByte));
        }
        return builder.toString();
    }

    public boolean isEmpty() {
        return this.subCount == 0;
    }

    public boolean isBlank() {
        boolean blank = true;
        for (byte sub : this.subs) {
            blank = blank && sub == 0;
        }
        return blank;
    }

    public byte[] getBytes() {
        byte[] bytes = new byte[8 + this.subCount * 4];
        bytes[0] = this.revision;
        bytes[1] = this.subCount;
        System.arraycopy(this.authority, 0, bytes, 2, 6);
        System.arraycopy(this.subs, 0, bytes, 8, this.subs.length);
        return bytes;
    }
}

