/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.marshall.spnego;

import com.kerb4j.server.marshall.Kerb4JException;
import com.kerb4j.server.marshall.spnego.KrbObjectIds;
import com.kerb4j.server.marshall.spnego.SpnegoKerberosMechToken;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kerby.asn1.Asn1FieldInfo;
import org.apache.kerby.asn1.EnumType;
import org.apache.kerby.asn1.ExplicitField;
import org.apache.kerby.asn1.parse.Asn1Container;
import org.apache.kerby.asn1.parse.Asn1ParseResult;
import org.apache.kerby.asn1.parse.Asn1Parser;
import org.apache.kerby.asn1.type.Asn1BitString;
import org.apache.kerby.asn1.type.Asn1ObjectIdentifier;
import org.apache.kerby.asn1.type.Asn1OctetString;
import org.apache.kerby.kerberos.kerb.type.KrbSequenceType;

public class SpnegoInitToken
extends KrbSequenceType {
    private static Asn1FieldInfo[] fieldInfos = new Asn1FieldInfo[]{new ExplicitField((EnumType)AuthorizationDataEntryField.MECH_TYPES, KrbObjectIds.class), new ExplicitField((EnumType)AuthorizationDataEntryField.REQ_FLAGS, Asn1BitString.class), new ExplicitField((EnumType)AuthorizationDataEntryField.MECH_TOKEN, Asn1OctetString.class), new ExplicitField((EnumType)AuthorizationDataEntryField.MECH_LIST_MIC, Asn1OctetString.class)};

    public SpnegoInitToken(byte[] token) throws Kerb4JException {
        super(fieldInfos);
        try {
            if (token.length <= 0) {
                throw new Kerb4JException("spnego.token.empty", null, null);
            }
            if (96 != token[0]) {
                throw new Kerb4JException("spnego.token.invalid", new Object[]{token[0]}, null);
            }
            Asn1ParseResult asn1ParseResult = Asn1Parser.parse((ByteBuffer)ByteBuffer.wrap(token));
            Asn1ParseResult item1 = (Asn1ParseResult)((Asn1Container)asn1ParseResult).getChildren().get(0);
            Asn1ObjectIdentifier asn1ObjectIdentifier = new Asn1ObjectIdentifier();
            asn1ObjectIdentifier.decode(item1);
            if (!((String)asn1ObjectIdentifier.getValue()).equals("1.3.6.1.5.5.2")) {
                throw new Kerb4JException("spnego.token.invalid", null, null);
            }
            Asn1ParseResult item2 = (Asn1ParseResult)((Asn1Container)asn1ParseResult).getChildren().get(1);
            this.decode((Asn1ParseResult)((Asn1Container)item2).getChildren().get(0));
        }
        catch (IOException e) {
            throw new Kerb4JException("spnego.token.malformed", null, e);
        }
    }

    public SpnegoKerberosMechToken getSpnegoKerberosMechToken() throws Kerb4JException {
        return new SpnegoKerberosMechToken(this.getMechToken());
    }

    public List<String> getMechTypes() {
        ArrayList<String> mechTypes = new ArrayList<String>();
        for (Asn1ObjectIdentifier objId : ((KrbObjectIds)this.getFieldAs(AuthorizationDataEntryField.MECH_TYPES, KrbObjectIds.class)).getElements()) {
            mechTypes.add((String)objId.getValue());
        }
        return mechTypes;
    }

    public String getMechanism() {
        List<String> mechTypes = this.getMechTypes();
        return null == mechTypes || mechTypes.isEmpty() ? null : mechTypes.get(0);
    }

    public int getReqFlags() {
        Asn1BitString reqFlags = (Asn1BitString)this.getFieldAs(AuthorizationDataEntryField.REQ_FLAGS, Asn1BitString.class);
        return null == reqFlags ? 0 : reqFlags.tagFlags();
    }

    public byte[] getMechToken() {
        return this.getFieldAsOctets(AuthorizationDataEntryField.MECH_TOKEN);
    }

    public byte[] getMechListMIC() {
        return this.getFieldAsOctets(AuthorizationDataEntryField.MECH_LIST_MIC);
    }

    protected static enum AuthorizationDataEntryField implements EnumType
    {
        MECH_TYPES,
        REQ_FLAGS,
        MECH_TOKEN,
        MECH_LIST_MIC;


        public int getValue() {
            return this.ordinal();
        }

        public String getName() {
            return this.name();
        }
    }
}

