/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.spring.ldap;

import com.kerb4j.client.SpnegoClient;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.security.auth.Subject;
import org.springframework.security.ldap.DefaultSpringSecurityContextSource;

public class KerberosLdapContextSource
extends DefaultSpringSecurityContextSource {
    private SpnegoClient spnegoClient;

    public KerberosLdapContextSource(String url) {
        super(url);
    }

    public KerberosLdapContextSource(List<String> urls, String baseDn) {
        super(urls, baseDn);
    }

    protected DirContext getDirContextInstance(final Hashtable<String, Object> environment) throws NamingException {
        environment.put("java.naming.security.authentication", "GSSAPI");
        Subject serviceSubject = this.spnegoClient.getSubject();
        final NamingException[] suppressedException = new NamingException[]{null};
        DirContext dirContext = Subject.doAs(serviceSubject, new PrivilegedAction<DirContext>(){

            @Override
            public DirContext run() {
                try {
                    return KerberosLdapContextSource.super.getDirContextInstance(environment);
                }
                catch (NamingException e) {
                    suppressedException[0] = e;
                    return null;
                }
            }
        });
        if (suppressedException[0] != null) {
            throw suppressedException[0];
        }
        return dirContext;
    }

    public SpnegoClient getSpnegoClient() {
        return this.spnegoClient;
    }

    public void setSpnegoClient(SpnegoClient spnegoClient) {
        this.spnegoClient = spnegoClient;
    }
}

