/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.client.spring;

import com.kerb4j.client.SpnegoClient;
import java.io.IOException;
import java.net.URI;
import java.security.PrivilegedActionException;
import java.util.List;
import org.ietf.jgss.GSSException;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequest;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class SpnegoRestTemplate
extends RestTemplate {
    private final SpnegoClient spnegoClient;

    public SpnegoRestTemplate(SpnegoClient spnegoClient) {
        this.spnegoClient = spnegoClient;
    }

    public SpnegoRestTemplate(ClientHttpRequestFactory requestFactory, SpnegoClient spnegoClient) {
        super(requestFactory);
        this.spnegoClient = spnegoClient;
    }

    public SpnegoRestTemplate(List<HttpMessageConverter<?>> messageConverters, SpnegoClient spnegoClient) {
        super(messageConverters);
        this.spnegoClient = spnegoClient;
    }

    protected <T> T doExecute(final URI uri, HttpMethod method, final RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return (T)super.doExecute(uri, method, new RequestCallback(){

            public void doWithRequest(ClientHttpRequest request) throws IOException {
                requestCallback.doWithRequest(request);
                try {
                    request.getHeaders().add("Authorization", SpnegoRestTemplate.this.spnegoClient.createAuthroizationHeader(uri.toURL()));
                }
                catch (IOException | PrivilegedActionException | GSSException e) {
                    throw new IOException(e);
                }
            }
        }, responseExtractor);
    }
}

