/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.spring;

import com.kerb4j.client.SpnegoClient;
import com.kerb4j.client.SpnegoContext;
import com.kerb4j.server.spring.ExtractGroupsUserDetailsService;
import com.kerb4j.server.spring.KerberosTicketValidator;
import com.kerb4j.server.spring.SpnegoAuthenticationToken;
import com.kerb4j.server.spring.SpnegoRequestToken;
import java.io.IOException;
import java.net.MalformedURLException;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.util.Assert;

public class SpnegoAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(SpnegoAuthenticationProvider.class);
    private KerberosTicketValidator ticketValidator;
    private UserDetailsService userDetailsService;
    private AuthenticationUserDetailsService<SpnegoAuthenticationToken> extractGroupsUserDetailsService = new ExtractGroupsUserDetailsService();
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private String serverSpn;

    public SpnegoAuthenticationToken authenticate(Authentication authentication) {
        UserDetails userGroupsDetails;
        String canonicalName = null;
        if (authentication instanceof UsernamePasswordAuthenticationToken) {
            canonicalName = authentication.getName();
            SpnegoClient spnegoClient = SpnegoClient.loginWithUsernamePassword((String)authentication.getName(), (String)authentication.getCredentials().toString(), (boolean)true);
            SpnegoContext context = null;
            try {
                context = spnegoClient.createContextForSPN(this.serverSpn);
                authentication = new SpnegoRequestToken(context.createToken());
            }
            catch (PrivilegedActionException e) {
                throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
            }
            catch (GSSException e) {
                throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
            }
            catch (MalformedURLException e) {
                throw new AuthenticationServiceException(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    if (null != context) {
                        context.close();
                    }
                }
                catch (IOException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        SpnegoRequestToken auth = (SpnegoRequestToken)((Object)authentication);
        byte[] token = auth.getToken();
        LOG.debug((Object)"Try to validate Kerberos Token");
        SpnegoAuthenticationToken ticketValidation = this.ticketValidator.validateTicket(token);
        LOG.debug((Object)("Successfully validated " + ticketValidation.username()));
        UserDetails userDetails = null != this.userDetailsService ? this.userDetailsService.loadUserByUsername(ticketValidation.username()) : null;
        userDetails = null == userDetails ? new User(ticketValidation.username(), "", Collections.emptySet()) : userDetails;
        UserDetails userDetails2 = userGroupsDetails = null != this.extractGroupsUserDetailsService ? this.extractGroupsUserDetailsService.loadUserDetails((Authentication)ticketValidation) : null;
        if (null != userGroupsDetails) {
            HashSet mergedAuthorities = new HashSet();
            if (null != userDetails.getAuthorities()) {
                mergedAuthorities.addAll(userDetails.getAuthorities());
            }
            if (null != userGroupsDetails.getAuthorities()) {
                mergedAuthorities.addAll(userGroupsDetails.getAuthorities());
            }
            userDetails = new User(userDetails.getUsername(), userDetails.getPassword(), userDetails.isEnabled(), userDetails.isAccountNonExpired(), userDetails.isCredentialsNonExpired(), userDetails.isAccountNonLocked(), mergedAuthorities);
        }
        this.userDetailsChecker.check(userDetails);
        this.additionalAuthenticationChecks(userDetails, auth);
        if (null == canonicalName) {
            canonicalName = userDetails.getUsername();
        }
        SpnegoAuthenticationToken responseAuth = new SpnegoAuthenticationToken(userDetails.getAuthorities(), ticketValidation.getToken(), canonicalName, ticketValidation.responseToken(), ticketValidation.getSubject(), ticketValidation.getKerberosKeys(), ticketValidation.getEtype());
        responseAuth.setDetails(authentication.getDetails());
        return responseAuth;
    }

    public boolean supports(Class<?> auth) {
        return SpnegoRequestToken.class.isAssignableFrom(auth) || null != this.serverSpn && UsernamePasswordAuthenticationToken.class.isAssignableFrom(auth);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.ticketValidator, (String)"ticketValidator must be specified");
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public void setExtractGroupsUserDetailsService(AuthenticationUserDetailsService<SpnegoAuthenticationToken> extractGroupsUserDetailsService) {
        this.extractGroupsUserDetailsService = extractGroupsUserDetailsService;
    }

    public void setTicketValidator(KerberosTicketValidator ticketValidator) {
        this.ticketValidator = ticketValidator;
    }

    protected void additionalAuthenticationChecks(UserDetails userDetails, SpnegoRequestToken authentication) throws AuthenticationException {
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = userDetailsChecker;
    }

    public void setServerSpn(String serverSpn) {
        this.serverSpn = serverSpn;
    }
}

