/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.spring;

import com.kerb4j.server.spring.SpnegoRequestToken;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.crypto.codec.Base64;

public class SpnegoAuthenticationToken
extends SpnegoRequestToken {
    private final String username;
    private final byte[] responseToken;
    private final Subject subject;
    private final KerberosKey[] kerberosKeys;
    private final String etype;

    public SpnegoAuthenticationToken(Collection<? extends GrantedAuthority> authorities, byte[] spnegoInitToken, String username, byte[] responseToken, Subject subject, KerberosKey[] kerberosKeys, String etype) {
        super(authorities, spnegoInitToken);
        this.username = username;
        this.responseToken = responseToken;
        this.subject = subject;
        this.kerberosKeys = kerberosKeys;
        this.etype = etype;
    }

    public SpnegoAuthenticationToken(byte[] token, String username, byte[] responseToken, Subject subject, KerberosKey[] kerberosKeys, String etype) {
        super(token);
        this.username = username;
        this.responseToken = responseToken;
        this.subject = subject;
        this.kerberosKeys = kerberosKeys;
        this.etype = etype;
    }

    public String username() {
        return this.username;
    }

    public byte[] responseToken() {
        return this.responseToken;
    }

    public boolean hasResponseToken() {
        return this.responseToken() != null;
    }

    public String getEncodedResponseToken() {
        if (!this.hasResponseToken()) {
            throw new IllegalStateException("Unauthenticated or no response token");
        }
        try {
            return new String(Base64.encode((byte[])this.responseToken()), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unable to encodeImpl response token", e);
        }
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public void setAuthenticated(boolean authenticated) {
        if (!authenticated) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Object getPrincipal() {
        return this.username;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public KerberosKey[] getKerberosKeys() {
        return this.kerberosKeys;
    }

    public String getEtype() {
        return this.etype;
    }
}

