/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.spring.jaas.sun;

import com.kerb4j.client.SpnegoClient;
import com.kerb4j.client.SpnegoContext;
import com.kerb4j.server.SpnegoTokenFixer;
import com.kerb4j.server.marshall.Kerb4JException;
import com.kerb4j.server.marshall.spnego.SpnegoInitToken;
import com.kerb4j.server.marshall.spnego.SpnegoKerberosMechToken;
import com.kerb4j.server.spring.KerberosTicketValidator;
import com.kerb4j.server.spring.SpnegoAuthenticationToken;
import java.io.IOException;
import java.security.PrivilegedActionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.kerby.kerberos.kerb.type.base.EncryptionType;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.util.Assert;

public class SunJaasKerberosTicketValidator
implements KerberosTicketValidator,
InitializingBean {
    private static final Log LOG = LogFactory.getLog(SunJaasKerberosTicketValidator.class);
    private String servicePrincipal;
    private String servicePassword;
    private Resource keyTabLocation;
    private boolean acceptOnly;
    private SpnegoClient spnegoClient;
    private boolean holdOnToGSSContext;

    @Override
    public SpnegoAuthenticationToken validateTicket(byte[] token) {
        SpnegoTokenFixer.fix((byte[])token);
        try {
            SpnegoContext acceptContext = this.spnegoClient.createAcceptContext();
            byte[] responseToken = acceptContext.acceptToken(token);
            GSSName srcName = acceptContext.getSrcName();
            if (null == srcName) {
                throw new BadCredentialsException("Kerberos validation not successful");
            }
            if (!this.holdOnToGSSContext) {
                acceptContext.close();
            }
            EncryptionType encryptionType = null;
            try {
                SpnegoInitToken spnegoInitToken = new SpnegoInitToken(token);
                SpnegoKerberosMechToken spnegoKerberosMechToken = spnegoInitToken.getSpnegoKerberosMechToken();
                encryptionType = spnegoKerberosMechToken.getApRequest().getTicket().getEncryptedEncPart().getEType();
            }
            catch (Kerb4JException e) {
                LOG.error((Object)"Failed to extract etype from spnego token", (Throwable)e);
            }
            return new SpnegoAuthenticationToken(token, srcName.toString(), responseToken, this.spnegoClient.getSubject(), this.spnegoClient.getKerberosKeys(), null == encryptionType ? null : encryptionType.getName());
        }
        catch (IOException | PrivilegedActionException | GSSException e) {
            throw new BadCredentialsException("Kerberos validation not successful", (Throwable)e);
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.servicePrincipal, (String)"servicePrincipal must be specified");
        Assert.state((null != this.keyTabLocation || null != this.servicePassword ? 1 : 0) != 0, (String)"Either password or keyTab must be specified");
        if (null != this.keyTabLocation) {
            String keyTabLocationAsString;
            if (this.keyTabLocation instanceof ClassPathResource) {
                LOG.warn((Object)"Your keytab is in the classpath. This file needs special protection and shouldn't be in the classpath. JAAS may also not be able to load this file from classpath.");
            }
            if ((keyTabLocationAsString = this.keyTabLocation.getURL().toExternalForm()).startsWith("file:")) {
                keyTabLocationAsString = keyTabLocationAsString.substring(5);
            }
            this.spnegoClient = SpnegoClient.loginWithKeyTab((String)this.servicePrincipal, (String)keyTabLocationAsString, (boolean)this.acceptOnly);
        } else {
            this.spnegoClient = SpnegoClient.loginWithUsernamePassword((String)this.servicePrincipal, (String)this.servicePassword);
        }
    }

    public void setServicePrincipal(String servicePrincipal) {
        this.servicePrincipal = servicePrincipal;
    }

    public void setKeyTabLocation(Resource keyTabLocation) {
        this.keyTabLocation = keyTabLocation;
    }

    public void setServicePassword(String servicePassword) {
        this.servicePassword = servicePassword;
    }

    public void setHoldOnToGSSContext(boolean holdOnToGSSContext) {
        this.holdOnToGSSContext = holdOnToGSSContext;
    }

    public void setAcceptOnly(boolean acceptOnly) {
        this.acceptOnly = acceptOnly;
    }
}

