/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.client.spring;

import com.kerb4j.common.util.base64.Base64Codec;
import java.net.URI;
import java.util.List;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.client.RequestCallback;
import org.springframework.web.client.ResponseExtractor;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

public class KerberosRestTemplate
extends RestTemplate {
    private final String authorizationHeader;

    public KerberosRestTemplate(String username, String password) {
        this.authorizationHeader = KerberosRestTemplate.getAuthorizationHeader(username, password);
    }

    public KerberosRestTemplate(ClientHttpRequestFactory requestFactory, String username, String password) {
        super(requestFactory);
        this.authorizationHeader = KerberosRestTemplate.getAuthorizationHeader(username, password);
    }

    public KerberosRestTemplate(List<HttpMessageConverter<?>> messageConverters, String username, String password) {
        super(messageConverters);
        this.authorizationHeader = KerberosRestTemplate.getAuthorizationHeader(username, password);
    }

    private static String getAuthorizationHeader(String username, String password) {
        return "Basic " + Base64Codec.encode((byte[])(username + ":" + password).getBytes());
    }

    protected <T> T doExecute(URI uri, String uriTemplate, HttpMethod method, RequestCallback requestCallback, ResponseExtractor<T> responseExtractor) throws RestClientException {
        return (T)super.doExecute(uri, uriTemplate, method, request -> {
            requestCallback.doWithRequest(request);
            request.getHeaders().add("Authorization", this.authorizationHeader);
        }, responseExtractor);
    }
}

