/*
 * Decompiled with CFR 0.152.
 */
package com.kerb4j.server.spring;

import com.kerb4j.common.util.base64.Base64Codec;
import com.kerb4j.server.spring.SpnegoRequestToken;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.util.Assert;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpnegoAuthenticationProcessingFilter
extends OncePerRequestFilter {
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private AuthenticationManager authenticationManager;
    private AuthenticationSuccessHandler authenticationSuccessHandler;
    private AuthenticationFailureHandler authenticationFailureHandler;
    private SessionAuthenticationStrategy sessionAuthenticationStrategy = new NullAuthenticatedSessionStrategy();
    private boolean skipIfAlreadyAuthenticated = true;
    private boolean supportBasicAuthentication;

    public SpnegoAuthenticationProcessingFilter() {
        this(true);
    }

    public SpnegoAuthenticationProcessingFilter(boolean supportBasicAuthentication) {
        this.supportBasicAuthentication = supportBasicAuthentication;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Authentication existingAuth;
        if (this.skipIfAlreadyAuthenticated && (existingAuth = SecurityContextHolder.getContext().getAuthentication()) != null && existingAuth.isAuthenticated() && !(existingAuth instanceof AnonymousAuthenticationToken)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String header = request.getHeader("Authorization");
        if (header != null) {
            Authentication authentication;
            Object authenticationRequest;
            if (header.startsWith("Negotiate")) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Received Negotiate Header for request " + request.getRequestURL() + ": " + header));
                }
                byte[] base64Token = header.substring(header.indexOf(" ") + 1).getBytes(StandardCharsets.UTF_8);
                byte[] kerberosTicket = Base64.decode((byte[])base64Token);
                authenticationRequest = new SpnegoRequestToken(kerberosTicket);
            } else if (this.supportBasicAuthentication && header.startsWith("Basic")) {
                String[] strings = this.extractAndDecodeHeader(header);
                authenticationRequest = new UsernamePasswordAuthenticationToken((Object)strings[0], (Object)strings[1]);
            } else {
                filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
                return;
            }
            authenticationRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
            try {
                authentication = this.authenticationManager.authenticate((Authentication)authenticationRequest);
            }
            catch (AuthenticationException e) {
                this.logger.warn((Object)("Negotiate Header was invalid: " + header), (Throwable)e);
                SecurityContextHolder.clearContext();
                if (this.authenticationFailureHandler != null) {
                    this.authenticationFailureHandler.onAuthenticationFailure(request, response, e);
                } else {
                    response.setStatus(401);
                    response.flushBuffer();
                }
                return;
            }
            this.sessionAuthenticationStrategy.onAuthentication(authentication, request, response);
            SecurityContextHolder.getContext().setAuthentication(authentication);
            if (this.authenticationSuccessHandler != null) {
                this.authenticationSuccessHandler.onAuthenticationSuccess(request, response, authentication);
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private String[] extractAndDecodeHeader(String header) {
        byte[] decoded;
        String base64Token = header.substring(6);
        try {
            decoded = Base64Codec.decode((String)base64Token);
        }
        catch (IllegalArgumentException e) {
            throw new BadCredentialsException("Failed to decode basic authentication token");
        }
        String token = new String(decoded, StandardCharsets.UTF_8);
        int delim = token.indexOf(":");
        if (delim == -1) {
            throw new BadCredentialsException("Invalid basic authentication token");
        }
        return new String[]{token.substring(0, delim), token.substring(delim + 1)};
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
        Assert.notNull((Object)this.authenticationManager, (String)"authenticationManager must be specified");
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public void setAuthenticationSuccessHandler(AuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }

    public void setAuthenticationFailureHandler(AuthenticationFailureHandler authenticationFailureHandler) {
        this.authenticationFailureHandler = authenticationFailureHandler;
    }

    public void setSkipIfAlreadyAuthenticated(boolean skipIfAlreadyAuthenticated) {
        this.skipIfAlreadyAuthenticated = skipIfAlreadyAuthenticated;
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionStrategy) {
        this.sessionAuthenticationStrategy = sessionStrategy;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public void setSupportBasicAuthentication(boolean supportBasicAuthentication) {
        this.supportBasicAuthentication = supportBasicAuthentication;
    }
}

