/*
 * Decompiled with CFR 0.152.
 */
package com.khubla.antlr.antlr4test;

import com.khubla.antlr.antlr4test.AssertErrorsException;
import com.khubla.antlr.antlr4test.FileUtil;
import com.khubla.antlr.antlr4test.Scenario;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.BaseErrorListener;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.apache.maven.plugin.logging.Log;

public class AssertErrorsErrorListener
extends BaseErrorListener {
    protected static final String CHAR_CR_PLACEHOLDER_REGEXP = "\\\\r";
    protected static final String CHAR_CR = String.valueOf('\r');
    protected static final String CHAR_LF_PLACEHOLDER_REGEXP = "\\\\n";
    protected static final String CHAR_LF = String.valueOf('\n');
    protected static final String LITERAL_BACKSLASH_R_PLACEHOLDER = "literal-backslash-r";
    protected static final String LITERAL_BACKSLASH_R = "\\\\r";
    protected static final String LITERAL_BACKSLASH_N_PLACEHOLDER = "literal-backslash-n";
    protected static final String LITERAL_BACKSLASH_N = "\\\\n";
    protected List<String> errorMessages = new ArrayList<String>();
    private Scenario scenario = null;
    private Log log = null;

    public AssertErrorsErrorListener(Scenario scenario, Log log) {
        this.scenario = scenario;
        this.log = log;
    }

    public void assertErrors(File errorMessagesFile, String encoding) throws AssertErrorsException {
        if (!this.errorMessages.isEmpty()) {
            List<String> expectedErrorMessages = null;
            String errorMessageFileName = null;
            if (errorMessagesFile != null) {
                errorMessageFileName = errorMessagesFile.getName();
            }
            try {
                expectedErrorMessages = FileUtil.getNonEmptyLines(errorMessagesFile, encoding);
            }
            catch (FileNotFoundException ex) {
                throw new AssertErrorsException(String.format("found %d errors, but missing file %s", this.errorMessages.size(), errorMessageFileName), ex);
            }
            catch (IOException ex) {
                throw new AssertErrorsException(String.format("found %d errors, unable to read file %s", this.errorMessages.size(), errorMessageFileName), ex);
            }
            this.asserts(expectedErrorMessages, errorMessageFileName);
        } else if (errorMessagesFile != null && errorMessagesFile.exists()) {
            throw new AssertErrorsException(String.format("no errors found, but errors file exists %s", errorMessagesFile.getAbsolutePath()));
        }
    }

    public void asserts(List<String> expectedErrorMessages, String errorMessageFileName) throws AssertErrorsException {
        int actualSize;
        List<String> expectedErrors = this.replacePlaceholders(expectedErrorMessages);
        List<String> actualErrors = this.replacePlaceholders(this.errorMessages);
        int expectedSize = expectedErrors.size();
        if (expectedSize != (actualSize = actualErrors.size())) {
            throw new AssertErrorsException(String.format("%s : expected %d errors, but was %d errors", errorMessageFileName, expectedSize, actualSize));
        }
        for (int i = 0; i < expectedSize; ++i) {
            String error;
            String expectedError = expectedErrors.get(i);
            if (expectedError.equals(error = actualErrors.get(i))) continue;
            throw new AssertErrorsException(String.format("%s : expected (%s), but was (%s)", errorMessageFileName, expectedError, error));
        }
    }

    public List<String> replacePlaceholders(List<String> stringList) {
        ArrayList<String> replacedStringList = new ArrayList<String>();
        for (String vString : stringList) {
            replacedStringList.add(this.replacePlaceholders(vString));
        }
        return replacedStringList;
    }

    protected String replacePlaceholders(String pString) {
        String result = pString;
        if (result != null) {
            result = result.replaceAll("\\\\r", CHAR_CR);
            result = result.replaceAll("\\\\n", CHAR_LF);
            result = result.replaceAll(LITERAL_BACKSLASH_R_PLACEHOLDER, "\\\\r");
            result = result.replaceAll(LITERAL_BACKSLASH_N_PLACEHOLDER, "\\\\n");
        }
        return result;
    }

    public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
        String errorMessage = String.format("line %d:%d %s", line, charPositionInLine, msg);
        if (this.scenario.isVerbose()) {
            this.log.warn((CharSequence)errorMessage);
        }
        this.errorMessages.add(errorMessage);
    }
}

