/*
 * Decompiled with CFR 0.152.
 */
package com.khubla.antlr.antlr4test;

import com.khubla.antlr.antlr4test.AssertErrorsErrorListener;
import com.khubla.antlr.antlr4test.CaseInsensitiveType;
import com.khubla.antlr.antlr4test.FileUtil;
import com.khubla.antlr.antlr4test.GrammarInitializer;
import com.khubla.antlr.antlr4test.GrammarTestMojo;
import com.khubla.antlr.antlr4test.Scenario;
import com.khubla.antlr.antlr4test.charstream.BinaryCharStream;
import com.khubla.antlr.antlr4test.filestream.AntlrCaseInsensitiveFileStream;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Lexer;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.Tree;
import org.antlr.v4.runtime.tree.Trees;
import org.apache.maven.plugin.logging.Log;
import org.bitbucket.cowwoc.diffmatchpatch.DiffMatchPatch;
import org.codehaus.plexus.util.FileUtils;

public class ScenarioExecutor {
    private Scenario scenario = null;
    private Log log = null;
    private GrammarTestMojo mojo = null;
    private final HashMap<URL, ClassLoader> classLoaderMap = new HashMap();

    public ScenarioExecutor(GrammarTestMojo mojo, Scenario scenario, Log log) {
        this.mojo = mojo;
        this.scenario = scenario;
        this.log = log;
    }

    private ClassLoader getClassLoader(String path) throws MalformedURLException, ClassNotFoundException {
        return this.getClassLoader(path, Thread.currentThread().getContextClassLoader());
    }

    private ClassLoader getClassLoader(String path, ClassLoader parent) throws MalformedURLException, ClassNotFoundException {
        URL antlrGeneratedURL = new File(path).toURI().toURL();
        ClassLoader ret = this.classLoaderMap.get(antlrGeneratedURL);
        if (ret == null) {
            URL[] urls = new URL[]{antlrGeneratedURL};
            ret = new URLClassLoader(urls, parent);
            this.classLoaderMap.put(antlrGeneratedURL, ret);
        }
        return ret;
    }

    private void testGrammar(Scenario scenario, File grammarFile) throws Exception {
        String treeFileData;
        String lispTree;
        File treeFile;
        Object nn = scenario.getGrammarName();
        if (null != scenario.getPackageName() && !"".equals(scenario.getPackageName())) {
            nn = scenario.getPackageName() + "." + scenario.getGrammarName();
        }
        String lexerClassName = (String)nn + "Lexer";
        String parserClassName = (String)nn + "Parser";
        if (scenario.isVerbose()) {
            this.log.info((CharSequence)("Lexer classname is: " + lexerClassName));
            this.log.info((CharSequence)("Parser classname is: " + parserClassName));
        }
        ClassLoader grammarClassLoader = this.getClassLoader(this.mojo.getOutputDirectory());
        ClassLoader testClassLoader = this.getClassLoader(this.mojo.getTestOutputDirectory(), grammarClassLoader);
        Class<Lexer> lexerClass = grammarClassLoader.loadClass(lexerClassName).asSubclass(Lexer.class);
        Class<Parser> parserClass = grammarClassLoader.loadClass(parserClassName).asSubclass(Parser.class);
        Class<GrammarInitializer> initializerClass = null;
        String grammarInitializer = scenario.getGrammarInitializer();
        if (grammarInitializer != null && !"".equals(grammarInitializer)) {
            initializerClass = testClassLoader.loadClass(grammarInitializer).asSubclass(GrammarInitializer.class);
        }
        Constructor<Lexer> lexerConstructor = lexerClass.getConstructor(CharStream.class);
        Constructor<Parser> parserConstructor = parserClass.getConstructor(TokenStream.class);
        this.log.info((CharSequence)("Parsing :" + grammarFile.getAbsolutePath()));
        Object antlrCharStream = scenario.getCaseInsensitiveType() == CaseInsensitiveType.None ? CharStreams.fromPath((Path)grammarFile.toPath(), (Charset)Charset.forName(scenario.getFileEncoding())) : new AntlrCaseInsensitiveFileStream(grammarFile.getAbsolutePath(), scenario.getFileEncoding(), scenario.getCaseInsensitiveType());
        if (scenario.getBinary()) {
            antlrCharStream = new BinaryCharStream((CharStream)antlrCharStream);
        }
        AssertErrorsErrorListener assertErrorsErrorListener = new AssertErrorsErrorListener(this.scenario, this.log);
        Lexer lexer = lexerConstructor.newInstance(antlrCharStream);
        lexer.addErrorListener((ANTLRErrorListener)assertErrorsErrorListener);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        Parser parser = parserConstructor.newInstance(tokens);
        parser.addErrorListener((ANTLRErrorListener)assertErrorsErrorListener);
        if (initializerClass != null) {
            this.log.info((CharSequence)initializerClass.getName());
            GrammarInitializer initializer = initializerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            initializer.initialize(lexer, parser);
        }
        if (scenario.isVerbose()) {
            tokens.fill();
            this.log.info((CharSequence)"Token List: ");
            for (Token tok : tokens.getTokens()) {
                String logmessage = tok.toString() + " {" + this.tokToHex(tok) + "}";
                this.log.info((CharSequence)logmessage);
            }
        }
        Method method = parserClass.getMethod(scenario.getEntryPoint(), new Class[0]);
        ParserRuleContext parserRuleContext = (ParserRuleContext)method.invoke((Object)parser, new Object[0]);
        assertErrorsErrorListener.assertErrors(new File(grammarFile.getAbsolutePath() + ".errors"), scenario.getFileEncoding());
        if (scenario.isShowTree()) {
            String lispTree2 = Trees.toStringTree((Tree)parserRuleContext, (Parser)parser);
            this.log.info((CharSequence)"Parsed Tree: ");
            this.log.info((CharSequence)lispTree2);
        }
        if ((treeFile = new File(grammarFile.getAbsolutePath() + ".tree")).exists() && null != (lispTree = Trees.toStringTree((Tree)parserRuleContext, (Parser)parser)) && null != (treeFileData = FileUtils.fileRead((File)treeFile, (String)scenario.getFileEncoding()))) {
            if (0 != treeFileData.compareTo(lispTree)) {
                StringBuilder sb = new StringBuilder("Parse tree does not match '" + treeFile.getName() + "'. Differences: ");
                for (DiffMatchPatch.Diff diff : new DiffMatchPatch().diffMain(treeFileData, lispTree)) {
                    sb.append(diff.toString());
                    sb.append(", ");
                }
                throw new Exception(sb.toString());
            }
            this.log.info((CharSequence)("Parse tree for '" + grammarFile.getName() + "' matches '" + treeFile.getName() + "'"));
        }
        parser = null;
        lexer = null;
        parserRuleContext = null;
        antlrCharStream = null;
    }

    public void testGrammars() throws Exception {
        List<File> exampleFiles = FileUtil.getAllFiles(this.scenario.getExampleFilesDir().getAbsolutePath());
        if (null != exampleFiles) {
            for (File file : exampleFiles) {
                if (!file.getName().endsWith(".errors") && !file.getName().endsWith(".tree") && (this.scenario.getTestFileExtension() == null || this.scenario.getTestFileExtension() != null && file.getName().endsWith(this.scenario.getTestFileExtension()))) {
                    this.testGrammar(this.scenario, file);
                }
                System.gc();
            }
        }
    }

    private String tokToHex(Token token) {
        Object ret = "";
        token.getInputStream().seek(0);
        boolean first = true;
        for (int i = token.getStartIndex(); i < token.getStopIndex() + 1; ++i) {
            if (first) {
                first = false;
            } else {
                ret = (String)ret + ",";
            }
            int t = token.getInputStream().LA(i + 1);
            ret = (String)ret + "0x" + String.format("%02X", (byte)t);
        }
        return ret;
    }
}

