/*
 * Decompiled with CFR 0.152.
 */
package com.khubla.antlr4formatter;

import com.khubla.antlr4formatter.Antlr4FormatterException;
import com.khubla.antlr4formatter.Antlr4FormatterListenerImpl;
import com.khubla.antlr4formatter.listener.FormatterParseTreeListenerImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.antlr.parser.antlr4.ANTLRv4Lexer;
import org.antlr.parser.antlr4.ANTLRv4Parser;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Antlr4Formatter {
    private static final Logger LOG = LoggerFactory.getLogger(Antlr4Formatter.class);

    public static void format(InputStream inputStream, OutputStream outputStream) {
        if (null == inputStream) {
            throw new IllegalArgumentException("Input stream must not be null!");
        }
        InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try (OutputStreamWriter writer = new OutputStreamWriter(outputStream);){
            Antlr4Formatter.formatGrammar((CharStream)CharStreams.fromReader((Reader)reader), writer);
        }
        catch (IOException e) {
            LOG.error("Could not format file", (Throwable)e);
        }
    }

    public static String format(String string) throws Antlr4FormatterException {
        try {
            if (null != string) {
                StringWriter writer = new StringWriter();
                CodePointCharStream input = CharStreams.fromString((String)string);
                Antlr4Formatter.formatGrammar((CharStream)input, writer);
                return writer.toString();
            }
            return "";
        }
        catch (Exception e) {
            throw new Antlr4FormatterException("Exception reading and parsing file", e);
        }
    }

    public static void formatDirectory(String inputDirOption) throws Antlr4FormatterException {
        List<String> files = new ArrayList<String>();
        files = Antlr4Formatter.listFilesFromDirectory(inputDirOption, files, ".g4");
        for (String filename : files) {
            File file = new File(filename);
            Antlr4Formatter.formatSingleFile(file, file);
        }
    }

    private static void formatGrammar(CharStream input, Writer output) {
        ANTLRv4Lexer lexer = new ANTLRv4Lexer(input);
        CommonTokenStream commonTokenStream = new CommonTokenStream((TokenSource)lexer);
        ANTLRv4Parser parser = new ANTLRv4Parser((TokenStream)commonTokenStream);
        ANTLRv4Parser.GrammarSpecContext grammarSpecContext = parser.grammarSpec();
        ParseTreeWalker.DEFAULT.walk((ParseTreeListener)new FormatterParseTreeListenerImpl(new Antlr4FormatterListenerImpl(output), commonTokenStream), (ParseTree)grammarSpecContext);
    }

    public static void formatSingleFile(File inputFile, File outputFile) throws Antlr4FormatterException {
        try {
            if (!inputFile.exists()) {
                throw new Exception("Unable to find: '" + inputFile + "'");
            }
            File tempFile = File.createTempFile(inputFile.getName(), ".g4");
            LOG.info("Formatting: {}", (Object)inputFile.getName());
            Antlr4Formatter.format(new FileInputStream(inputFile), new FileOutputStream(tempFile));
            Files.copy(tempFile.toPath(), outputFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            Files.delete(tempFile.toPath());
        }
        catch (Exception e) {
            throw new Antlr4FormatterException("Exception fromatting file", e);
        }
    }

    public static void formatSingleFile(String inputFilename, String outputFilename) throws Antlr4FormatterException {
        File inputFile = new File(inputFilename);
        File outputFile = null == outputFilename ? inputFile : new File(outputFilename);
        Antlr4Formatter.formatSingleFile(inputFile, outputFile);
    }

    private static List<String> listFilesFromDirectory(String dir, List<String> files, String filter) {
        File file = new File(dir);
        String[] list = file.list();
        if (null != list) {
            for (String s : list) {
                String fileName = dir + (dir.endsWith("/") ? "" : "/") + s;
                File f2 = new File(fileName);
                if (f2.isHidden()) continue;
                if (f2.isDirectory()) {
                    Antlr4Formatter.listFilesFromDirectory(fileName + "/", files, filter);
                    continue;
                }
                if (!fileName.endsWith(filter)) continue;
                files.add(fileName);
            }
        }
        return files;
    }

    private Antlr4Formatter() {
    }
}

