/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.kickstarter.dropwizard.metrics.influxdb.AutoValue_InfluxDbMeasurement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public abstract class InfluxDbMeasurement {
    public abstract String name();

    public abstract Map<String, String> tags();

    public abstract Map<String, String> fields();

    public abstract long timestamp();

    public static InfluxDbMeasurement create(String name, Map<String, String> tags, Map<String, String> fields, long timestamp) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0, (Object)"InfluxDbMeasurement must contain a non-empty name");
        Preconditions.checkArgument((!fields.isEmpty() ? 1 : 0) != 0, (Object)"InfluxDbMeasurement must contain at least one field");
        return new AutoValue_InfluxDbMeasurement(name, tags, fields, timestamp);
    }

    public String toLine() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name());
        if (!this.tags().isEmpty()) {
            sb.append(',');
            sb.append(InfluxDbMeasurement.joinPairs(this.tags()));
        }
        if (!this.fields().isEmpty()) {
            sb.append(' ');
            sb.append(InfluxDbMeasurement.joinPairs(this.fields()));
        }
        sb.append(' ');
        sb.append(TimeUnit.NANOSECONDS.convert(this.timestamp(), TimeUnit.MILLISECONDS));
        return sb.toString();
    }

    public String toString() {
        return this.toLine();
    }

    @VisibleForTesting
    static String joinPairs(Map<String, String> pairs) {
        List pairStrs = pairs.entrySet().parallelStream().map(e -> String.join((CharSequence)"=", (CharSequence)e.getKey(), (CharSequence)e.getValue())).collect(Collectors.toList());
        return String.join((CharSequence)",", pairStrs);
    }

    public static class Builder {
        private final String name;
        private final long timestamp;
        private final Map<String, String> tags = new HashMap<String, String>();
        private final Map<String, String> fields = new HashMap<String, String>();

        public Builder(String name, long timestamp) {
            this.name = name;
            this.timestamp = timestamp;
        }

        public boolean isValid() {
            return !this.name.isEmpty() && !this.fields.isEmpty();
        }

        public Builder putTags(Map<String, String> items) {
            this.tags.putAll(items);
            return this;
        }

        public Builder putTag(String key, String value) {
            this.tags.put(key, value);
            return this;
        }

        public <T> Builder putFields(Map<String, T> fields) {
            fields.forEach(this::putField);
            return this;
        }

        public <T> Builder tryPutFields(Map<String, T> fields, Consumer<IllegalArgumentException> exceptionHandler) {
            for (Map.Entry<String, T> field : fields.entrySet()) {
                try {
                    this.putField(field.getKey(), field.getValue());
                }
                catch (IllegalArgumentException e) {
                    exceptionHandler.accept(e);
                }
            }
            return this;
        }

        public <T> Builder putField(String key, T value) {
            if (value == null) {
                return this;
            }
            if (value instanceof Float) {
                float f = ((Float)value).floatValue();
                if (!Float.isNaN(f) && !Float.isInfinite(f)) {
                    this.fields.put(key, String.valueOf(f));
                }
            } else if (value instanceof Double) {
                double d = (Double)value;
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    this.fields.put(key, String.valueOf(d));
                }
            } else if (value instanceof Integer || value instanceof Long) {
                this.fields.put(key, String.format("%di", ((Number)value).longValue()));
            } else if (value instanceof String || value instanceof Boolean) {
                this.fields.put(key, value.toString());
            } else {
                throw new IllegalArgumentException(String.format("InfluxDbMeasurement field '%s' must be String or primitive: %s", key, value));
            }
            return this;
        }

        public InfluxDbMeasurement build() {
            return InfluxDbMeasurement.create(this.name, this.tags, this.fields, this.timestamp);
        }
    }
}

