/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.Timer;
import com.google.common.collect.ImmutableList;
import com.kickstarter.dropwizard.metrics.influxdb.InfluxDbMeasurement;
import com.kickstarter.dropwizard.metrics.influxdb.io.Sender;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.DropwizardTransformer;
import java.time.Clock;
import java.util.Collection;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class InfluxDbMeasurementReporter
extends ScheduledReporter {
    private final Clock clock;
    private final Sender sender;
    private final DropwizardTransformer transformer;

    public InfluxDbMeasurementReporter(Sender sender, MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, DropwizardTransformer transformer, ScheduledExecutorService executor) {
        super(registry, "influxdb-measurement-reporter", filter, rateUnit, durationUnit, executor);
        this.clock = clock;
        this.sender = sender;
        this.transformer = transformer;
    }

    public InfluxDbMeasurementReporter(Sender sender, MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, Clock clock, DropwizardTransformer transformer) {
        super(registry, "influxdb-measurement-reporter", filter, rateUnit, durationUnit);
        this.clock = clock;
        this.sender = sender;
        this.transformer = transformer;
    }

    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        long timestamp = this.clock.instant().toEpochMilli();
        ImmutableList influxDbMeasurements = ImmutableList.builder().addAll(this.transformer.fromGauges(gauges, timestamp)).addAll(this.transformer.fromCounters(counters, timestamp)).addAll(this.transformer.fromHistograms(histograms, timestamp)).addAll(this.transformer.fromMeters(meters, timestamp)).addAll(this.transformer.fromTimers(timers, timestamp)).build();
        this.sender.send((Collection<InfluxDbMeasurement>)influxDbMeasurements);
    }
}

