/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.annotations.VisibleForTesting;
import com.kickstarter.dropwizard.metrics.influxdb.InfluxDbMeasurementReporter;
import com.kickstarter.dropwizard.metrics.influxdb.io.InfluxDbHttpWriter;
import com.kickstarter.dropwizard.metrics.influxdb.io.InfluxDbWriter;
import com.kickstarter.dropwizard.metrics.influxdb.io.Sender;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.DropwizardMeasurementParser;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.DropwizardTransformer;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.TaggedPattern;
import io.dropwizard.metrics.BaseReporterFactory;
import java.time.Clock;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;

@JsonTypeName(value="influxdb")
public class InfluxDbMeasurementReporterFactory
extends BaseReporterFactory {
    @NotNull
    @JsonProperty
    private Map<String, String> globalTags = new HashMap<String, String>();
    @NotNull
    @JsonProperty
    private Map<String, TaggedPattern> metricTemplates = new HashMap<String, TaggedPattern>();
    @NotNull
    @JsonProperty
    private boolean groupGauges = true;
    @NotNull
    @JsonProperty
    private boolean groupCounters = true;
    @NotNull
    @JsonProperty
    private InfluxDbWriter.Factory sender = new InfluxDbHttpWriter.Factory();

    @VisibleForTesting
    Map<String, String> globalTags() {
        return this.globalTags;
    }

    @VisibleForTesting
    Map<String, TaggedPattern> metricTemplates() {
        return this.metricTemplates;
    }

    @VisibleForTesting
    boolean groupGauges() {
        return this.groupGauges;
    }

    @VisibleForTesting
    boolean groupCounters() {
        return this.groupCounters;
    }

    @VisibleForTesting
    InfluxDbWriter.Factory sender() {
        return this.sender;
    }

    public ScheduledReporter build(MetricRegistry registry) {
        Sender builtSender = new Sender(this.sender.build(registry));
        DropwizardTransformer transformer = new DropwizardTransformer(this.globalTags, DropwizardMeasurementParser.withTemplates(this.metricTemplates), this.groupCounters, this.groupGauges, this.getRateUnit(), this.getDurationUnit());
        return new InfluxDbMeasurementReporter(builtSender, registry, this.getFilter(), this.getRateUnit(), this.getDurationUnit(), Clock.systemUTC(), transformer);
    }
}

