/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb.io;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.kickstarter.dropwizard.metrics.influxdb.io.InfluxDbWriter;
import io.dropwizard.client.JerseyClientBuilder;
import io.dropwizard.client.JerseyClientConfiguration;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.concurrent.Executors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

public class InfluxDbHttpWriter
implements InfluxDbWriter {
    private final Client client;
    private final WebTarget influxLines;

    public InfluxDbHttpWriter(Client client, String endpoint) {
        this.client = client;
        this.influxLines = client.target(endpoint);
    }

    @Override
    public void writeBytes(byte[] bytes) {
        this.influxLines.request().post(Entity.entity((Object)bytes, (MediaType)MediaType.APPLICATION_OCTET_STREAM_TYPE));
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }

    public static class Factory
    implements InfluxDbWriter.Factory {
        @NotBlank
        @JsonProperty
        private String host = "localhost";
        @Range(min=0L, max=49151L)
        @JsonProperty
        private int port = 8086;
        @JsonProperty
        private JerseyClientConfiguration jersey = new JerseyClientConfiguration();
        @NotBlank
        @JsonProperty
        private String database;

        @Override
        public InfluxDbWriter build(MetricRegistry metrics) {
            Client client = new JerseyClientBuilder(metrics).using(this.jersey).using(new ObjectMapper()).using(Executors.newSingleThreadExecutor()).build("influxdb-http-writer");
            try {
                String query = "/write?db=" + URLEncoder.encode(this.database, "UTF-8");
                URL endpoint = new URL("http", this.host, this.port, query);
                return new InfluxDbHttpWriter(client, endpoint.toString());
            }
            catch (UnsupportedEncodingException | MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

