/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb.io;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.kickstarter.dropwizard.metrics.influxdb.io.InfluxDbWriter;
import io.dropwizard.util.Duration;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.Range;

public class InfluxDbTcpWriter
implements InfluxDbWriter {
    private final String host;
    private final int port;
    private final Duration timeout;
    private Socket tcpSocket;

    public InfluxDbTcpWriter(String host, int port, Duration timeout) {
        this.host = host;
        this.port = port;
        this.timeout = timeout;
    }

    @Override
    public void writeBytes(byte[] bytes) throws IOException {
        if (this.tcpSocket == null) {
            this.tcpSocket = new Socket(this.host, this.port);
            this.tcpSocket.setSoTimeout((int)this.timeout.toMilliseconds());
        }
        OutputStream outputStream = this.tcpSocket.getOutputStream();
        outputStream.write(bytes);
        outputStream.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.tcpSocket != null) {
            this.tcpSocket.close();
            this.tcpSocket = null;
        }
    }

    public static class Factory
    implements InfluxDbWriter.Factory {
        @NotBlank
        @JsonProperty
        private String host = "localhost";
        @Range(min=0L, max=49151L)
        @JsonProperty
        private int port = 8086;
        @NotNull
        @JsonProperty
        private Duration timeout = Duration.milliseconds((long)500L);

        public String host() {
            return this.host;
        }

        public int port() {
            return this.port;
        }

        public Duration timeout() {
            return this.timeout;
        }

        @Override
        public InfluxDbWriter build(MetricRegistry __) {
            return new InfluxDbTcpWriter(this.host, this.port, this.timeout);
        }
    }
}

