/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb.io;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.EvictingQueue;
import com.kickstarter.dropwizard.metrics.influxdb.InfluxDbMeasurement;
import com.kickstarter.dropwizard.metrics.influxdb.io.InfluxDbTcpWriter;
import com.kickstarter.dropwizard.metrics.influxdb.io.InfluxDbWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sender {
    private static final Logger log = LoggerFactory.getLogger(InfluxDbTcpWriter.class);
    public static final int DEFAULT_QUEUE_SIZE = 5000;
    private static final String SEPARATOR = "\n";
    private final InfluxDbWriter writer;
    private final EvictingQueue<InfluxDbMeasurement> queuedInfluxDbMeasurements;

    public Sender(InfluxDbWriter writer) {
        this(writer, 5000);
    }

    public Sender(InfluxDbWriter writer, int queueSize) {
        this.writer = writer;
        this.queuedInfluxDbMeasurements = EvictingQueue.create((int)queueSize);
    }

    @VisibleForTesting
    int queuedMeasures() {
        return this.queuedInfluxDbMeasurements.size();
    }

    public boolean send(Collection<InfluxDbMeasurement> influxDbMeasurements) {
        this.queuedInfluxDbMeasurements.addAll(influxDbMeasurements);
        if (this.queuedInfluxDbMeasurements.isEmpty()) {
            return true;
        }
        String measureLines = String.join((CharSequence)SEPARATOR, this.queuedInfluxDbMeasurements.stream().map(InfluxDbMeasurement::toLine).collect(Collectors.toList())) + SEPARATOR;
        try {
            byte[] measureBytes = measureLines.getBytes("UTF-8");
            this.writer.writeBytes(measureBytes);
            this.queuedInfluxDbMeasurements.clear();
            return true;
        }
        catch (UnsupportedEncodingException e) {
            log.warn("failed to send metrics", (Throwable)e);
        }
        catch (Exception e) {
            log.warn("failed to send metrics", (Throwable)e);
            try {
                this.writer.close();
            }
            catch (Exception e2) {
                log.warn("failed to close metrics connection", (Throwable)e2);
            }
        }
        if (this.queuedInfluxDbMeasurements.remainingCapacity() == 0) {
            log.warn("Queued measurements at capacity");
        }
        return false;
    }
}

