/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb.transformer;

import com.kickstarter.dropwizard.metrics.influxdb.transformer.AutoValue_DropwizardMeasurement;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class DropwizardMeasurement {
    private static final String FIELD_SEPARATOR = " ";
    private static final String TAG_SEPARATOR = ",";
    private static final String VALUE_SEPARATOR = "=";
    private static final String ESCAPE_CHARS = " |,|=";
    private static final String SANITIZER = "-";

    abstract String name();

    abstract Map<String, String> tags();

    abstract Optional<String> field();

    private static String sanitize(String s) {
        return s.replaceAll(ESCAPE_CHARS, SANITIZER);
    }

    public static DropwizardMeasurement create(String name, Map<String, String> tags, Optional<String> field) {
        Map<String, String> sanitizedTags = tags.entrySet().stream().collect(Collectors.toMap(e -> DropwizardMeasurement.sanitize((String)e.getKey()), e -> DropwizardMeasurement.sanitize((String)e.getValue())));
        return new AutoValue_DropwizardMeasurement(DropwizardMeasurement.sanitize(name), sanitizedTags, field.map(DropwizardMeasurement::sanitize));
    }

    public static DropwizardMeasurement fromLine(String line) {
        String[] initialParts = line.split(FIELD_SEPARATOR);
        if (initialParts.length > 2) {
            throw new IllegalArgumentException("too many spaces in measurement line");
        }
        Optional<String> field = initialParts.length == 2 ? Optional.of(initialParts[1]) : Optional.empty();
        String[] parts = initialParts[0].split(TAG_SEPARATOR);
        String name = parts[0];
        Map<String, String> tags = Arrays.asList(parts).subList(1, parts.length).stream().map(s -> s.split(VALUE_SEPARATOR)).filter(arr -> ((String[])arr).length == 2).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]));
        if (tags.size() != parts.length - 1) {
            throw new IllegalArgumentException("tags must contain exactly one '=' character");
        }
        return DropwizardMeasurement.create(name, tags, field);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name());
        this.tags().forEach((k, v) -> {
            builder.append(TAG_SEPARATOR);
            builder.append((String)k);
            builder.append(VALUE_SEPARATOR);
            builder.append((String)v);
        });
        if (this.field().isPresent()) {
            builder.append(FIELD_SEPARATOR);
            builder.append(this.field().orElse(""));
        }
        return builder.toString();
    }
}

