/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb.transformer;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.DropwizardMeasurement;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.TaggedPattern;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class DropwizardMeasurementParser {
    private static final ImmutableMap<String, TaggedPattern> DROPWIZARD_METRIC_MAPPINGS = ImmutableMap.builder().put((Object)"health", (Object)new TaggedPattern(".*\\.health\\.(?<check>.*)", new String[0])).put((Object)"resources", (Object)new TaggedPattern(".*\\.resources?\\.(?<resource>[A-Za-z]+)\\.(?<method>[A-Za-z]+)", "resource", "method")).put((Object)"jvm", (Object)new TaggedPattern("^jvm$", new String[0])).put((Object)"jvm_attribute", (Object)new TaggedPattern("jvm\\.attribute.*?", new String[0])).put((Object)"jvm_buffers", (Object)new TaggedPattern("jvm\\.buffers\\.?(?<type>.*)", "type")).put((Object)"jvm_classloader", (Object)new TaggedPattern("jvm\\.classloader.*", new String[0])).put((Object)"jvm_gc", (Object)new TaggedPattern("jvm\\.gc\\.?(?<metric>.*)", "metric")).put((Object)"jvm_memory", (Object)new TaggedPattern("jvm\\.memory\\.?(?<metric>.*)", "metric")).put((Object)"jvm_threads", (Object)new TaggedPattern("jvm\\.threads\\.?(?<metric>.*)", "metric")).put((Object)"logging", (Object)new TaggedPattern("ch\\.qos\\.logback\\.core\\.Appender\\.(?<level>.*)", "level")).put((Object)"raw_sql", (Object)new TaggedPattern("org\\.skife\\.jdbi\\.v2\\.DBI\\.raw-sql", new String[0])).put((Object)"clients", (Object)new TaggedPattern("org\\.apache\\.http\\.client\\.HttpClient\\.(?<client>.*)\\.(?<metric>.*)$", "client", "metric")).put((Object)"client_connections", (Object)new TaggedPattern("org\\.apache\\.http\\.conn\\.HttpClientConnectionManager\\.(?<client>.*)", "client")).put((Object)"connections", (Object)new TaggedPattern("org\\.eclipse\\.jetty\\.server\\.HttpConnectionFactory\\.(?<port>[0-9]+).*", "port")).put((Object)"thread_pools", (Object)new TaggedPattern("org\\.eclipse\\.jetty\\.util\\.thread\\.QueuedThreadPool\\.(?<pool>.*)", "pool")).put((Object)"http_server", (Object)new TaggedPattern("io\\.dropwizard\\.jetty\\.MutableServletContextHandler\\.?(?<metric>.*)", "metric")).put((Object)"data_sources", (Object)new TaggedPattern("io\\.dropwizard\\.db\\.ManagedPooledDataSource\\.(?<metric>.*)", "metric")).build();
    private final ImmutableMap<String, TaggedPattern> metricTemplates;
    private final Map<String, DropwizardMeasurement> cache = new HashMap<String, DropwizardMeasurement>();

    @VisibleForTesting
    DropwizardMeasurementParser(ImmutableMap<String, TaggedPattern> metricTemplates) {
        this.metricTemplates = metricTemplates;
    }

    public static DropwizardMeasurementParser withTemplates(Map<String, TaggedPattern> metricTemplates) {
        return new DropwizardMeasurementParser((ImmutableMap<String, TaggedPattern>)new ImmutableMap.Builder().putAll(metricTemplates).putAll(DROPWIZARD_METRIC_MAPPINGS).build());
    }

    DropwizardMeasurement parse(String metricName) {
        return this.cache.computeIfAbsent(metricName, __ -> this.templatedMeasurement(metricName).orElseGet(() -> DropwizardMeasurement.fromLine(metricName)));
    }

    private Optional<DropwizardMeasurement> templatedMeasurement(String metricName) {
        for (Map.Entry entry : this.metricTemplates.entrySet()) {
            Optional<DropwizardMeasurement> measurement = ((TaggedPattern)entry.getValue()).tags(metricName).map(tags -> DropwizardMeasurement.create((String)entry.getKey(), tags, Optional.empty()));
            if (!measurement.isPresent()) continue;
            return measurement;
        }
        return Optional.empty();
    }
}

