/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb.transformer;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.annotations.VisibleForTesting;
import com.kickstarter.dropwizard.metrics.influxdb.InfluxDbMeasurement;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.DropwizardMeasurement;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.DropwizardMeasurementParser;
import com.kickstarter.dropwizard.metrics.influxdb.transformer.GroupKey;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DropwizardTransformer {
    private static final Logger log = LoggerFactory.getLogger(DropwizardTransformer.class);
    private final Map<String, String> baseTags;
    private final DropwizardMeasurementParser parser;
    private final boolean groupCounters;
    private final boolean groupGauges;
    private final long rateFactor;
    private final long durationFactor;

    public DropwizardTransformer(Map<String, String> baseTags, DropwizardMeasurementParser parser, boolean groupCounters, boolean groupGauges, TimeUnit rateUnit, TimeUnit durationUnit) {
        this.baseTags = baseTags;
        this.parser = parser;
        this.groupCounters = groupCounters;
        this.groupGauges = groupGauges;
        this.rateFactor = rateUnit.toSeconds(1L);
        this.durationFactor = durationUnit.toNanos(1L);
    }

    @VisibleForTesting
    double convertDuration(double duration) {
        return duration / (double)this.durationFactor;
    }

    @VisibleForTesting
    double convertRate(double rate) {
        return rate * (double)this.rateFactor;
    }

    public List<InfluxDbMeasurement> fromTimers(Map<String, Timer> timers, long timestamp) {
        return timers.entrySet().stream().map(e -> this.fromTimer((String)e.getKey(), (Timer)e.getValue(), timestamp)).collect(Collectors.toList());
    }

    @VisibleForTesting
    InfluxDbMeasurement fromTimer(String metricName, Timer t, long timestamp) {
        Snapshot snapshot = t.getSnapshot();
        DropwizardMeasurement measurement = this.parser.parse(metricName);
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(measurement.tags());
        return new InfluxDbMeasurement.Builder(measurement.name(), timestamp).putTags(tags).putField("count", snapshot.size()).putField("min", this.convertDuration(snapshot.getMin())).putField("max", this.convertDuration(snapshot.getMax())).putField("mean", this.convertDuration(snapshot.getMean())).putField("std-dev", this.convertDuration(snapshot.getStdDev())).putField("50-percentile", this.convertDuration(snapshot.getMedian())).putField("75-percentile", this.convertDuration(snapshot.get75thPercentile())).putField("95-percentile", this.convertDuration(snapshot.get95thPercentile())).putField("99-percentile", this.convertDuration(snapshot.get99thPercentile())).putField("999-percentile", this.convertDuration(snapshot.get999thPercentile())).putField("one-minute", this.convertRate(t.getOneMinuteRate())).putField("five-minute", this.convertRate(t.getFiveMinuteRate())).putField("fifteen-minute", this.convertRate(t.getFifteenMinuteRate())).putField("mean-minute", this.convertRate(t.getMeanRate())).putField("run-count", t.getCount()).build();
    }

    public List<InfluxDbMeasurement> fromMeters(Map<String, Meter> meters, long timestamp) {
        return meters.entrySet().stream().map(e -> this.fromMeter((String)e.getKey(), (Meter)e.getValue(), timestamp)).collect(Collectors.toList());
    }

    @VisibleForTesting
    InfluxDbMeasurement fromMeter(String metricName, Meter mt, long timestamp) {
        DropwizardMeasurement measurement = this.parser.parse(metricName);
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(measurement.tags());
        return new InfluxDbMeasurement.Builder(measurement.name(), timestamp).putTags(tags).putField("count", mt.getCount()).putField("one-minute", this.convertRate(mt.getOneMinuteRate())).putField("five-minute", this.convertRate(mt.getFiveMinuteRate())).putField("fifteen-minute", this.convertRate(mt.getFifteenMinuteRate())).putField("mean-minute", this.convertRate(mt.getMeanRate())).build();
    }

    public List<InfluxDbMeasurement> fromHistograms(Map<String, Histogram> histograms, long timestamp) {
        return histograms.entrySet().stream().map(e -> this.fromHistogram((String)e.getKey(), (Histogram)e.getValue(), timestamp)).collect(Collectors.toList());
    }

    @VisibleForTesting
    InfluxDbMeasurement fromHistogram(String metricName, Histogram h, long timestamp) {
        Snapshot snapshot = h.getSnapshot();
        DropwizardMeasurement measurement = this.parser.parse(metricName);
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(measurement.tags());
        return new InfluxDbMeasurement.Builder(measurement.name(), timestamp).putTags(tags).putField("count", snapshot.size()).putField("min", snapshot.getMin()).putField("max", snapshot.getMax()).putField("mean", snapshot.getMean()).putField("std-dev", snapshot.getStdDev()).putField("50-percentile", snapshot.getMedian()).putField("75-percentile", snapshot.get75thPercentile()).putField("95-percentile", snapshot.get95thPercentile()).putField("99-percentile", snapshot.get99thPercentile()).putField("999-percentile", snapshot.get999thPercentile()).putField("run-count", h.getCount()).build();
    }

    public List<InfluxDbMeasurement> fromCounters(Map<String, Counter> counters, long timestamp) {
        return this.fromCounterOrGauge(counters, "count", Counter::getCount, timestamp, this.groupCounters);
    }

    public List<InfluxDbMeasurement> fromGauges(Map<String, Gauge> gauges, long timestamp) {
        return this.fromCounterOrGauge(gauges, "value", Gauge::getValue, timestamp, this.groupGauges);
    }

    private <T, R> List<InfluxDbMeasurement> fromCounterOrGauge(Map<String, T> items, String defaultFieldName, Function<T, R> valueExtractor, long timestamp, boolean group) {
        if (group) {
            Map<GroupKey, Map<String, R>> groupedItems = this.groupValues(items, defaultFieldName, valueExtractor);
            return groupedItems.entrySet().stream().map(entry -> this.fromValueGroup((GroupKey)entry.getKey(), (Map)entry.getValue(), timestamp)).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        return items.entrySet().stream().map(entry -> this.fromKeyValue((String)entry.getKey(), defaultFieldName, valueExtractor.apply(entry.getValue()), timestamp)).collect(Collectors.toList());
    }

    @VisibleForTesting
    <T> InfluxDbMeasurement fromKeyValue(String metricName, String defaultFieldName, T value, long timestamp) {
        DropwizardMeasurement measurement = this.parser.parse(metricName);
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(measurement.tags());
        return new InfluxDbMeasurement.Builder(measurement.name(), timestamp).putTags(tags).putField(defaultFieldName, value).build();
    }

    @VisibleForTesting
    <T, R> Map<GroupKey, Map<String, R>> groupValues(Map<String, T> items, String defaultFieldName, Function<T, R> valueExtractor) {
        HashMap groupedValues = new HashMap();
        items.forEach((key, item) -> {
            String field;
            String measurementKey;
            if (key.contains(" ") || key.contains(",")) {
                measurementKey = key;
                field = this.parser.parse((String)key).field().orElse(defaultFieldName);
            } else {
                boolean hasCountPostfix = key.endsWith(".count");
                String mainKey = hasCountPostfix ? key.substring(0, key.length() - 6) : key;
                int lastDotIndex = mainKey.lastIndexOf(".");
                if (lastDotIndex == -1) {
                    measurementKey = mainKey;
                    field = hasCountPostfix ? "count" : defaultFieldName;
                } else {
                    measurementKey = mainKey.substring(0, lastDotIndex);
                    field = key.substring(lastDotIndex + 1);
                }
            }
            DropwizardMeasurement measurement = this.parser.parse(measurementKey);
            GroupKey groupKey = GroupKey.create(measurement.name(), measurement.tags());
            Map fields = groupedValues.getOrDefault(groupKey, new HashMap());
            fields.put(field, valueExtractor.apply(item));
            groupedValues.put(groupKey, fields);
        });
        return groupedValues;
    }

    @VisibleForTesting
    <T> Optional<InfluxDbMeasurement> fromValueGroup(GroupKey groupKey, Map<String, T> fields, long timestamp) {
        HashMap<String, String> tags = new HashMap<String, String>(this.baseTags);
        tags.putAll(groupKey.tags());
        InfluxDbMeasurement.Builder builder = new InfluxDbMeasurement.Builder(groupKey.measurement(), timestamp).putTags(tags).tryPutFields(fields, e -> log.warn(e.getMessage()));
        if (builder.isValid()) {
            log.warn("Measurement has no valid fields: {}", (Object)groupKey.measurement());
            return Optional.of(builder.build());
        }
        return Optional.empty();
    }
}

