/*
 * Decompiled with CFR 0.152.
 */
package com.kickstarter.dropwizard.metrics.influxdb.transformer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.NotBlank;

public class TaggedPattern {
    @NotBlank
    @JsonProperty
    private String pattern;
    @NotNull
    @JsonProperty
    private List<String> tagKeys;
    private final Pattern compiledPattern;

    public String pattern() {
        return this.pattern;
    }

    public List<String> tagKeys() {
        return this.tagKeys;
    }

    @JsonCreator
    public TaggedPattern(String pattern, List<String> tagKeys) {
        this.pattern = pattern;
        this.tagKeys = tagKeys;
        this.compiledPattern = Pattern.compile(pattern);
    }

    @VisibleForTesting
    TaggedPattern(String pattern, String ... tagKeys) {
        this(pattern, Arrays.asList(tagKeys));
    }

    Optional<Map<String, String>> tags(CharSequence input) {
        Matcher matcher = this.compiledPattern.matcher(input);
        if (matcher.matches()) {
            return Optional.of(this.tagKeys.stream().filter(tag -> !matcher.group((String)tag).isEmpty()).collect(Collectors.toMap(Function.identity(), matcher::group)));
        }
        return Optional.empty();
    }
}

