/*
 * Decompiled with CFR 0.152.
 */
package com.king.bravo.testing.actions;

import com.king.bravo.testing.BravoTestPipeline;
import com.king.bravo.testing.PipelineAction;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.flink.streaming.api.checkpoint.ListCheckpointed;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.watermark.Watermark;

public class TestPipelineSource
implements SourceFunction<String>,
ListCheckpointed<Serializable> {
    private static final long serialVersionUID = 1L;
    private static long DEFAULT_SLEEP = 100L;
    private volatile boolean isRunning = false;
    private int index = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(SourceFunction.SourceContext<String> ctx) throws Exception {
        this.isRunning = true;
        while (this.index < BravoTestPipeline.actions.size()) {
            if (!this.isRunning) {
                return;
            }
            PipelineAction nextAction = BravoTestPipeline.actions.get(this.index);
            Object object = ctx.getCheckpointLock();
            synchronized (object) {
                ++this.index;
                nextAction.withCheckpointLock(ctx);
            }
            nextAction.executeClusterAction(BravoTestPipeline.client, BravoTestPipeline.jobID);
            Thread.sleep(DEFAULT_SLEEP);
        }
        Thread.sleep(DEFAULT_SLEEP);
        ctx.emitWatermark(new Watermark(Long.MAX_VALUE));
    }

    public void cancel() {
        this.isRunning = false;
    }

    public void restoreState(List<Serializable> s) throws Exception {
        this.index = (Integer)s.get(0);
    }

    public List<Serializable> snapshotState(long arg0, long arg1) throws Exception {
        return Collections.singletonList(this.index);
    }
}

