/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.InternalClient;
import com.kintone.client.KintoneApi;
import com.kintone.client.ResponseHandler;
import com.kintone.client.api.app.AddAppRequest;
import com.kintone.client.api.app.AddAppResponseBody;
import com.kintone.client.api.app.AddFormFieldsRequest;
import com.kintone.client.api.app.AddFormFieldsResponseBody;
import com.kintone.client.api.app.DeleteFormFieldsRequest;
import com.kintone.client.api.app.DeleteFormFieldsResponseBody;
import com.kintone.client.api.app.DeployAppRequest;
import com.kintone.client.api.app.DeployAppResponseBody;
import com.kintone.client.api.app.EvaluateRecordAclRequest;
import com.kintone.client.api.app.EvaluateRecordAclResponseBody;
import com.kintone.client.api.app.GetAppAclPreviewRequest;
import com.kintone.client.api.app.GetAppAclPreviewResponseBody;
import com.kintone.client.api.app.GetAppAclRequest;
import com.kintone.client.api.app.GetAppAclResponseBody;
import com.kintone.client.api.app.GetAppActionsPreviewRequest;
import com.kintone.client.api.app.GetAppActionsPreviewResponseBody;
import com.kintone.client.api.app.GetAppActionsRequest;
import com.kintone.client.api.app.GetAppActionsResponseBody;
import com.kintone.client.api.app.GetAppCustomizePreviewRequest;
import com.kintone.client.api.app.GetAppCustomizePreviewResponseBody;
import com.kintone.client.api.app.GetAppCustomizeRequest;
import com.kintone.client.api.app.GetAppCustomizeResponseBody;
import com.kintone.client.api.app.GetAppRequest;
import com.kintone.client.api.app.GetAppResponseBody;
import com.kintone.client.api.app.GetAppSettingsPreviewRequest;
import com.kintone.client.api.app.GetAppSettingsPreviewResponseBody;
import com.kintone.client.api.app.GetAppSettingsRequest;
import com.kintone.client.api.app.GetAppSettingsResponseBody;
import com.kintone.client.api.app.GetAppsRequest;
import com.kintone.client.api.app.GetAppsResponseBody;
import com.kintone.client.api.app.GetDeployStatusRequest;
import com.kintone.client.api.app.GetDeployStatusResponseBody;
import com.kintone.client.api.app.GetFieldAclPreviewRequest;
import com.kintone.client.api.app.GetFieldAclPreviewResponseBody;
import com.kintone.client.api.app.GetFieldAclRequest;
import com.kintone.client.api.app.GetFieldAclResponseBody;
import com.kintone.client.api.app.GetFormFieldsPreviewRequest;
import com.kintone.client.api.app.GetFormFieldsPreviewResponseBody;
import com.kintone.client.api.app.GetFormFieldsRequest;
import com.kintone.client.api.app.GetFormFieldsResponseBody;
import com.kintone.client.api.app.GetFormLayoutPreviewRequest;
import com.kintone.client.api.app.GetFormLayoutPreviewResponseBody;
import com.kintone.client.api.app.GetFormLayoutRequest;
import com.kintone.client.api.app.GetFormLayoutResponseBody;
import com.kintone.client.api.app.GetGeneralNotificationsPreviewRequest;
import com.kintone.client.api.app.GetGeneralNotificationsPreviewResponseBody;
import com.kintone.client.api.app.GetGeneralNotificationsRequest;
import com.kintone.client.api.app.GetGeneralNotificationsResponseBody;
import com.kintone.client.api.app.GetPerRecordNotificationsPreviewRequest;
import com.kintone.client.api.app.GetPerRecordNotificationsPreviewResponseBody;
import com.kintone.client.api.app.GetPerRecordNotificationsRequest;
import com.kintone.client.api.app.GetPerRecordNotificationsResponseBody;
import com.kintone.client.api.app.GetProcessManagementPreviewRequest;
import com.kintone.client.api.app.GetProcessManagementPreviewResponseBody;
import com.kintone.client.api.app.GetProcessManagementRequest;
import com.kintone.client.api.app.GetProcessManagementResponseBody;
import com.kintone.client.api.app.GetRecordAclPreviewRequest;
import com.kintone.client.api.app.GetRecordAclPreviewResponseBody;
import com.kintone.client.api.app.GetRecordAclRequest;
import com.kintone.client.api.app.GetRecordAclResponseBody;
import com.kintone.client.api.app.GetReminderNotificationsPreviewRequest;
import com.kintone.client.api.app.GetReminderNotificationsPreviewResponseBody;
import com.kintone.client.api.app.GetReminderNotificationsRequest;
import com.kintone.client.api.app.GetReminderNotificationsResponseBody;
import com.kintone.client.api.app.GetReportsPreviewRequest;
import com.kintone.client.api.app.GetReportsPreviewResponseBody;
import com.kintone.client.api.app.GetReportsRequest;
import com.kintone.client.api.app.GetReportsResponseBody;
import com.kintone.client.api.app.GetViewsPreviewRequest;
import com.kintone.client.api.app.GetViewsPreviewResponseBody;
import com.kintone.client.api.app.GetViewsRequest;
import com.kintone.client.api.app.GetViewsResponseBody;
import com.kintone.client.api.app.UpdateAppAclRequest;
import com.kintone.client.api.app.UpdateAppAclResponseBody;
import com.kintone.client.api.app.UpdateAppActionsRequest;
import com.kintone.client.api.app.UpdateAppActionsResponseBody;
import com.kintone.client.api.app.UpdateAppCustomizeRequest;
import com.kintone.client.api.app.UpdateAppCustomizeResponseBody;
import com.kintone.client.api.app.UpdateAppSettingsRequest;
import com.kintone.client.api.app.UpdateAppSettingsResponseBody;
import com.kintone.client.api.app.UpdateFieldAclRequest;
import com.kintone.client.api.app.UpdateFieldAclResponseBody;
import com.kintone.client.api.app.UpdateFormFieldsRequest;
import com.kintone.client.api.app.UpdateFormFieldsResponseBody;
import com.kintone.client.api.app.UpdateFormLayoutRequest;
import com.kintone.client.api.app.UpdateFormLayoutResponseBody;
import com.kintone.client.api.app.UpdateGeneralNotificationsRequest;
import com.kintone.client.api.app.UpdateGeneralNotificationsResponseBody;
import com.kintone.client.api.app.UpdatePerRecordNotificationsRequest;
import com.kintone.client.api.app.UpdatePerRecordNotificationsResponseBody;
import com.kintone.client.api.app.UpdateProcessManagementRequest;
import com.kintone.client.api.app.UpdateProcessManagementResponseBody;
import com.kintone.client.api.app.UpdateRecordAclRequest;
import com.kintone.client.api.app.UpdateRecordAclResponseBody;
import com.kintone.client.api.app.UpdateReminderNotificationsRequest;
import com.kintone.client.api.app.UpdateReminderNotificationsResponseBody;
import com.kintone.client.api.app.UpdateReportsRequest;
import com.kintone.client.api.app.UpdateReportsResponseBody;
import com.kintone.client.api.app.UpdateViewsRequest;
import com.kintone.client.api.app.UpdateViewsResponseBody;
import com.kintone.client.model.app.ActionId;
import com.kintone.client.model.app.App;
import com.kintone.client.model.app.AppAction;
import com.kintone.client.model.app.AppRightEntity;
import com.kintone.client.model.app.DeployApp;
import com.kintone.client.model.app.DeployStatus;
import com.kintone.client.model.app.EvaluatedRecordRight;
import com.kintone.client.model.app.FieldRight;
import com.kintone.client.model.app.RecordRight;
import com.kintone.client.model.app.View;
import com.kintone.client.model.app.ViewId;
import com.kintone.client.model.app.field.FieldProperty;
import com.kintone.client.model.app.layout.Layout;
import com.kintone.client.model.app.report.Report;
import com.kintone.client.model.app.report.ReportId;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppClient {
    private final InternalClient client;
    private final List<ResponseHandler> handlers;

    public long addApp(String name) {
        return this.addApp(name, null, null);
    }

    public long addApp(String name, Long spaceId, Long threadId) {
        AddAppRequest req = new AddAppRequest();
        req.setName(name);
        req.setSpace(spaceId);
        req.setThread(threadId);
        return this.addApp(req).getApp();
    }

    public AddAppResponseBody addApp(AddAppRequest request) {
        return (AddAppResponseBody)this.client.call(KintoneApi.ADD_APP, request, this.handlers);
    }

    public long addFormFields(long app, List<FieldProperty> properties) {
        return this.addFormFields(app, properties, null);
    }

    public long addFormFields(long app, List<FieldProperty> properties, Long revision) {
        Map<String, FieldProperty> map = properties.stream().collect(Collectors.toMap(FieldProperty::getCode, v -> v));
        return this.addFormFields(app, map, revision);
    }

    public long addFormFields(long app, Map<String, FieldProperty> properties) {
        return this.addFormFields(app, properties, null);
    }

    public long addFormFields(long app, Map<String, FieldProperty> properties, Long revision) {
        AddFormFieldsRequest req = new AddFormFieldsRequest();
        req.setApp(app);
        req.setProperties(properties);
        req.setRevision(revision);
        return this.addFormFields(req).getRevision();
    }

    public AddFormFieldsResponseBody addFormFields(AddFormFieldsRequest request) {
        return (AddFormFieldsResponseBody)this.client.call(KintoneApi.ADD_FORM_FIELDS, request, this.handlers);
    }

    public long deleteFormFields(long app, List<String> fields) {
        return this.deleteFormFields(app, fields, null);
    }

    public long deleteFormFields(long app, List<String> fields, Long revision) {
        DeleteFormFieldsRequest req = new DeleteFormFieldsRequest();
        req.setApp(app);
        req.setFields(fields);
        req.setRevision(revision);
        return this.deleteFormFields(req).getRevision();
    }

    public DeleteFormFieldsResponseBody deleteFormFields(DeleteFormFieldsRequest request) {
        return (DeleteFormFieldsResponseBody)this.client.call(KintoneApi.DELETE_FORM_FIELDS, request, this.handlers);
    }

    public void deployApp(long app) {
        this.deployApp(app, null, false);
    }

    public void deployApp(long app, Long revision) {
        this.deployApp(app, revision, false);
    }

    private void deployApp(long app, Long revision, boolean revert) {
        DeployApp deployApp = new DeployApp();
        deployApp.setApp(app);
        deployApp.setRevision(revision);
        ArrayList<DeployApp> apps = new ArrayList<DeployApp>();
        apps.add(deployApp);
        DeployAppRequest req = new DeployAppRequest();
        req.setApps(apps);
        req.setRevert(revert);
        this.deployApp(req);
    }

    public DeployAppResponseBody deployApp(DeployAppRequest request) {
        return (DeployAppResponseBody)this.client.call(KintoneApi.DEPLOY_APP, request, this.handlers);
    }

    public EvaluatedRecordRight evaluateRecordAcl(long app, long recordId) {
        ArrayList<Long> recordIds = new ArrayList<Long>();
        recordIds.add(recordId);
        return this.evaluateRecordAcl(app, recordIds).get(0);
    }

    public List<EvaluatedRecordRight> evaluateRecordAcl(long app, List<Long> recordIds) {
        EvaluateRecordAclRequest req = new EvaluateRecordAclRequest();
        req.setApp(app);
        req.setIds(recordIds);
        return this.evaluateRecordAcl(req).getRights();
    }

    public EvaluateRecordAclResponseBody evaluateRecordAcl(EvaluateRecordAclRequest request) {
        return (EvaluateRecordAclResponseBody)this.client.call(KintoneApi.EVALUATE_RECORD_ACL, request, this.handlers);
    }

    public App getApp(long id) {
        GetAppRequest request = new GetAppRequest();
        request.setId(id);
        GetAppResponseBody response = this.getApp(request);
        return new App(response.getAppId(), response.getCode(), response.getName(), response.getDescription(), response.getSpaceId(), response.getThreadId(), response.getCreatedAt(), response.getCreator(), response.getModifiedAt(), response.getModifier());
    }

    public GetAppResponseBody getApp(GetAppRequest request) {
        return (GetAppResponseBody)this.client.call(KintoneApi.GET_APP, request, this.handlers);
    }

    public List<AppRightEntity> getAppAcl(long app) {
        GetAppAclRequest req = new GetAppAclRequest();
        req.setApp(app);
        return this.getAppAcl(req).getRights();
    }

    public GetAppAclResponseBody getAppAcl(GetAppAclRequest request) {
        return (GetAppAclResponseBody)this.client.call(KintoneApi.GET_APP_ACL, request, this.handlers);
    }

    public List<AppRightEntity> getAppAclPreview(long app) {
        GetAppAclPreviewRequest req = new GetAppAclPreviewRequest();
        req.setApp(app);
        return this.getAppAclPreview(req).getRights();
    }

    public GetAppAclPreviewResponseBody getAppAclPreview(GetAppAclPreviewRequest request) {
        return (GetAppAclPreviewResponseBody)this.client.call(KintoneApi.GET_APP_ACL_PREVIEW, request, this.handlers);
    }

    public Map<String, AppAction> getAppActions(long app) {
        GetAppActionsRequest req = new GetAppActionsRequest();
        req.setApp(app);
        return this.getAppActions(req).getActions();
    }

    public Map<String, AppAction> getAppActions(long app, String lang) {
        GetAppActionsRequest req = new GetAppActionsRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getAppActions(req).getActions();
    }

    public GetAppActionsResponseBody getAppActions(GetAppActionsRequest request) {
        return (GetAppActionsResponseBody)this.client.call(KintoneApi.GET_APP_ACTIONS, request, this.handlers);
    }

    public Map<String, AppAction> getAppActionsPreview(long app) {
        GetAppActionsPreviewRequest req = new GetAppActionsPreviewRequest();
        req.setApp(app);
        return this.getAppActionsPreview(req).getActions();
    }

    public Map<String, AppAction> getAppActionsPreview(long app, String lang) {
        GetAppActionsPreviewRequest req = new GetAppActionsPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getAppActionsPreview(req).getActions();
    }

    public GetAppActionsPreviewResponseBody getAppActionsPreview(GetAppActionsPreviewRequest request) {
        return (GetAppActionsPreviewResponseBody)this.client.call(KintoneApi.GET_APP_ACTIONS_PREVIEW, request, this.handlers);
    }

    public GetAppCustomizeResponseBody getAppCustomize(long app) {
        GetAppCustomizeRequest req = new GetAppCustomizeRequest();
        req.setApp(app);
        return this.getAppCustomize(req);
    }

    public GetAppCustomizeResponseBody getAppCustomize(GetAppCustomizeRequest request) {
        return (GetAppCustomizeResponseBody)this.client.call(KintoneApi.GET_APP_CUSTOMIZE, request, this.handlers);
    }

    public GetAppCustomizePreviewResponseBody getAppCustomizePreview(long app) {
        GetAppCustomizePreviewRequest req = new GetAppCustomizePreviewRequest();
        req.setApp(app);
        return this.getAppCustomizePreview(req);
    }

    public GetAppCustomizePreviewResponseBody getAppCustomizePreview(GetAppCustomizePreviewRequest request) {
        return (GetAppCustomizePreviewResponseBody)this.client.call(KintoneApi.GET_APP_CUSTOMIZE_PREVIEW, request, this.handlers);
    }

    public GetAppsResponseBody getApps(GetAppsRequest request) {
        return (GetAppsResponseBody)this.client.call(KintoneApi.GET_APPS, request, this.handlers);
    }

    public List<App> getAppsByCodes(List<String> codes) {
        GetAppsRequest req = new GetAppsRequest();
        req.setCodes(codes);
        return this.getApps(req).getApps();
    }

    public List<App> getAppsByIds(List<Long> ids) {
        GetAppsRequest req = new GetAppsRequest();
        req.setIds(ids);
        return this.getApps(req).getApps();
    }

    public GetAppSettingsResponseBody getAppSettings(long app) {
        return this.getAppSettings(app, null);
    }

    public GetAppSettingsResponseBody getAppSettings(long app, String lang) {
        GetAppSettingsRequest req = new GetAppSettingsRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getAppSettings(req);
    }

    public GetAppSettingsResponseBody getAppSettings(GetAppSettingsRequest request) {
        return (GetAppSettingsResponseBody)this.client.call(KintoneApi.GET_APP_SETTINGS, request, this.handlers);
    }

    public GetAppSettingsPreviewResponseBody getAppSettingsPreview(long app) {
        return this.getAppSettingsPreview(app, null);
    }

    public GetAppSettingsPreviewResponseBody getAppSettingsPreview(long app, String lang) {
        GetAppSettingsPreviewRequest req = new GetAppSettingsPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getAppSettingsPreview(req);
    }

    public GetAppSettingsPreviewResponseBody getAppSettingsPreview(GetAppSettingsPreviewRequest request) {
        return (GetAppSettingsPreviewResponseBody)this.client.call(KintoneApi.GET_APP_SETTINGS_PREVIEW, request, this.handlers);
    }

    public DeployStatus getDeployStatus(long app) {
        GetDeployStatusRequest req = new GetDeployStatusRequest();
        ArrayList<Long> apps = new ArrayList<Long>();
        apps.add(app);
        req.setApps(apps);
        return this.getDeployStatus(req).getApps().get(0).getStatus();
    }

    public GetDeployStatusResponseBody getDeployStatus(GetDeployStatusRequest request) {
        return (GetDeployStatusResponseBody)this.client.call(KintoneApi.GET_DEPLOY_STATUS, request, this.handlers);
    }

    public List<FieldRight> getFieldAcl(long app) {
        GetFieldAclRequest req = new GetFieldAclRequest();
        req.setApp(app);
        return this.getFieldAcl(req).getRights();
    }

    public GetFieldAclResponseBody getFieldAcl(GetFieldAclRequest request) {
        return (GetFieldAclResponseBody)this.client.call(KintoneApi.GET_FIELD_ACL, request, this.handlers);
    }

    public List<FieldRight> getFieldAclPreview(long app) {
        GetFieldAclPreviewRequest req = new GetFieldAclPreviewRequest();
        req.setApp(app);
        return this.getFieldAclPreview(req).getRights();
    }

    public GetFieldAclPreviewResponseBody getFieldAclPreview(GetFieldAclPreviewRequest request) {
        return (GetFieldAclPreviewResponseBody)this.client.call(KintoneApi.GET_FIELD_ACL_PREVIEW, request, this.handlers);
    }

    public Map<String, FieldProperty> getFormFields(long app) {
        return this.getFormFields(app, null);
    }

    public Map<String, FieldProperty> getFormFields(long app, String lang) {
        GetFormFieldsRequest req = new GetFormFieldsRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getFormFields(req).getProperties();
    }

    public GetFormFieldsResponseBody getFormFields(GetFormFieldsRequest request) {
        return (GetFormFieldsResponseBody)this.client.call(KintoneApi.GET_FORM_FIELDS, request, this.handlers);
    }

    public Map<String, FieldProperty> getFormFieldsPreview(long app) {
        return this.getFormFieldsPreview(app, null);
    }

    public Map<String, FieldProperty> getFormFieldsPreview(long app, String lang) {
        GetFormFieldsPreviewRequest req = new GetFormFieldsPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getFormFieldsPreview(req).getProperties();
    }

    public GetFormFieldsPreviewResponseBody getFormFieldsPreview(GetFormFieldsPreviewRequest request) {
        return (GetFormFieldsPreviewResponseBody)this.client.call(KintoneApi.GET_FORM_FIELDS_PREVIEW, request, this.handlers);
    }

    public List<Layout> getFormLayout(long app) {
        GetFormLayoutRequest req = new GetFormLayoutRequest();
        req.setApp(app);
        return this.getFormLayout(req).getLayout();
    }

    public GetFormLayoutResponseBody getFormLayout(GetFormLayoutRequest request) {
        return (GetFormLayoutResponseBody)this.client.call(KintoneApi.GET_FORM_LAYOUT, request, this.handlers);
    }

    public List<Layout> getFormLayoutPreview(long app) {
        GetFormLayoutPreviewRequest req = new GetFormLayoutPreviewRequest();
        req.setApp(app);
        return this.getFormLayoutPreview(req).getLayout();
    }

    public GetFormLayoutPreviewResponseBody getFormLayoutPreview(GetFormLayoutPreviewRequest request) {
        return (GetFormLayoutPreviewResponseBody)this.client.call(KintoneApi.GET_FORM_LAYOUT_PREVIEW, request, this.handlers);
    }

    public GetGeneralNotificationsResponseBody getGeneralNotifications(long app) {
        GetGeneralNotificationsRequest req = new GetGeneralNotificationsRequest();
        req.setApp(app);
        return (GetGeneralNotificationsResponseBody)this.client.call(KintoneApi.GET_GENERAL_NOTIFICATIONS, req, this.handlers);
    }

    public GetGeneralNotificationsResponseBody getGeneralNotifications(GetGeneralNotificationsRequest request) {
        return (GetGeneralNotificationsResponseBody)this.client.call(KintoneApi.GET_GENERAL_NOTIFICATIONS, request, this.handlers);
    }

    public GetGeneralNotificationsPreviewResponseBody getGeneralNotificationsPreview(long app) {
        GetGeneralNotificationsPreviewRequest req = new GetGeneralNotificationsPreviewRequest();
        req.setApp(app);
        return (GetGeneralNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_GENERAL_NOTIFICATIONS_PREVIEW, req, this.handlers);
    }

    public GetGeneralNotificationsPreviewResponseBody getGeneralNotificationsPreview(GetGeneralNotificationsPreviewRequest request) {
        return (GetGeneralNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_GENERAL_NOTIFICATIONS_PREVIEW, request, this.handlers);
    }

    public GetPerRecordNotificationsResponseBody getPerRecordNotifications(long app) {
        GetPerRecordNotificationsRequest req = new GetPerRecordNotificationsRequest();
        req.setApp(app);
        return (GetPerRecordNotificationsResponseBody)this.client.call(KintoneApi.GET_PRE_RECORD_NOTIFICATIONS, req, this.handlers);
    }

    public GetPerRecordNotificationsResponseBody getPerRecordNotifications(long app, String lang) {
        GetPerRecordNotificationsRequest req = new GetPerRecordNotificationsRequest();
        req.setApp(app);
        req.setLang(lang);
        return (GetPerRecordNotificationsResponseBody)this.client.call(KintoneApi.GET_PRE_RECORD_NOTIFICATIONS, req, this.handlers);
    }

    public GetPerRecordNotificationsResponseBody getPerRecordNotifications(GetPerRecordNotificationsRequest request) {
        return (GetPerRecordNotificationsResponseBody)this.client.call(KintoneApi.GET_PRE_RECORD_NOTIFICATIONS, request, this.handlers);
    }

    public GetPerRecordNotificationsPreviewResponseBody getPerRecordNotificationsPreview(long app) {
        GetPerRecordNotificationsPreviewRequest req = new GetPerRecordNotificationsPreviewRequest();
        req.setApp(app);
        return (GetPerRecordNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_PRE_RECORD_NOTIFICATIONS_PREVIEW, req, this.handlers);
    }

    public GetPerRecordNotificationsPreviewResponseBody getPerRecordNotificationsPreview(long app, String lang) {
        GetPerRecordNotificationsPreviewRequest req = new GetPerRecordNotificationsPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return (GetPerRecordNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_PRE_RECORD_NOTIFICATIONS_PREVIEW, req, this.handlers);
    }

    public GetPerRecordNotificationsPreviewResponseBody getPerRecordNotificationsPreview(GetPerRecordNotificationsPreviewRequest request) {
        return (GetPerRecordNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_PRE_RECORD_NOTIFICATIONS_PREVIEW, request, this.handlers);
    }

    public GetProcessManagementResponseBody getProcessManagement(long app) {
        return this.getProcessManagement(app, null);
    }

    public GetProcessManagementResponseBody getProcessManagement(long app, String lang) {
        GetProcessManagementRequest req = new GetProcessManagementRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getProcessManagement(req);
    }

    public GetProcessManagementResponseBody getProcessManagement(GetProcessManagementRequest request) {
        return (GetProcessManagementResponseBody)this.client.call(KintoneApi.GET_PROCESS_MANAGEMENT, request, this.handlers);
    }

    public GetProcessManagementPreviewResponseBody getProcessManagementPreview(long app) {
        return this.getProcessManagementPreview(app, null);
    }

    public GetProcessManagementPreviewResponseBody getProcessManagementPreview(long app, String lang) {
        GetProcessManagementPreviewRequest req = new GetProcessManagementPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getProcessManagementPreview(req);
    }

    public GetProcessManagementPreviewResponseBody getProcessManagementPreview(GetProcessManagementPreviewRequest request) {
        return (GetProcessManagementPreviewResponseBody)this.client.call(KintoneApi.GET_PROCESS_MANAGEMENT_PREVIEW, request, this.handlers);
    }

    public List<RecordRight> getRecordAcl(long app) {
        return this.getRecordAcl(app, null);
    }

    public List<RecordRight> getRecordAcl(long app, String lang) {
        GetRecordAclRequest req = new GetRecordAclRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getRecordAcl(req).getRights();
    }

    public GetRecordAclResponseBody getRecordAcl(GetRecordAclRequest request) {
        return (GetRecordAclResponseBody)this.client.call(KintoneApi.GET_RECORD_ACL, request, this.handlers);
    }

    public List<RecordRight> getRecordAclPreview(long app) {
        return this.getRecordAclPreview(app, null);
    }

    public List<RecordRight> getRecordAclPreview(long app, String lang) {
        GetRecordAclPreviewRequest req = new GetRecordAclPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getRecordAclPreview(req).getRights();
    }

    public GetRecordAclPreviewResponseBody getRecordAclPreview(GetRecordAclPreviewRequest request) {
        return (GetRecordAclPreviewResponseBody)this.client.call(KintoneApi.GET_RECORD_ACL_PREVIEW, request, this.handlers);
    }

    public GetReminderNotificationsResponseBody getReminderNotifications(long app) {
        GetReminderNotificationsRequest req = new GetReminderNotificationsRequest();
        req.setApp(app);
        return (GetReminderNotificationsResponseBody)this.client.call(KintoneApi.GET_REMINDER_NOTIFICATIONS, req, this.handlers);
    }

    public GetReminderNotificationsResponseBody getReminderNotifications(long app, String lang) {
        GetReminderNotificationsRequest req = new GetReminderNotificationsRequest();
        req.setApp(app);
        req.setLang(lang);
        return (GetReminderNotificationsResponseBody)this.client.call(KintoneApi.GET_REMINDER_NOTIFICATIONS, req, this.handlers);
    }

    public GetReminderNotificationsResponseBody getReminderNotifications(GetReminderNotificationsRequest request) {
        return (GetReminderNotificationsResponseBody)this.client.call(KintoneApi.GET_REMINDER_NOTIFICATIONS, request, this.handlers);
    }

    public GetReminderNotificationsPreviewResponseBody getReminderNotificationsPreview(long app) {
        GetReminderNotificationsPreviewRequest req = new GetReminderNotificationsPreviewRequest();
        req.setApp(app);
        return (GetReminderNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_REMINDER_NOTIFICATIONS_PREVIEW, req, this.handlers);
    }

    public GetReminderNotificationsPreviewResponseBody getReminderNotificationsPreview(long app, String lang) {
        GetReminderNotificationsPreviewRequest req = new GetReminderNotificationsPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return (GetReminderNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_REMINDER_NOTIFICATIONS_PREVIEW, req, this.handlers);
    }

    public GetReminderNotificationsPreviewResponseBody getReminderNotificationsPreview(GetReminderNotificationsPreviewRequest request) {
        return (GetReminderNotificationsPreviewResponseBody)this.client.call(KintoneApi.GET_REMINDER_NOTIFICATIONS_PREVIEW, request, this.handlers);
    }

    public Map<String, Report> getReports(long app) {
        GetReportsRequest req = new GetReportsRequest();
        req.setApp(app);
        return this.getReports(req).getReports();
    }

    public Map<String, Report> getReports(long app, String lang) {
        GetReportsRequest req = new GetReportsRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getReports(req).getReports();
    }

    public GetReportsResponseBody getReports(GetReportsRequest request) {
        return (GetReportsResponseBody)this.client.call(KintoneApi.GET_REPORTS, request, this.handlers);
    }

    public Map<String, Report> getReportsPreview(long app) {
        GetReportsPreviewRequest req = new GetReportsPreviewRequest();
        req.setApp(app);
        return this.getReportsPreview(req).getReports();
    }

    public Map<String, Report> getReportsPreview(long app, String lang) {
        GetReportsPreviewRequest req = new GetReportsPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getReportsPreview(req).getReports();
    }

    public GetReportsPreviewResponseBody getReportsPreview(GetReportsPreviewRequest request) {
        return (GetReportsPreviewResponseBody)this.client.call(KintoneApi.GET_REPORTS_PREVIEW, request, this.handlers);
    }

    public Map<String, View> getViews(long app) {
        return this.getViews(app, null);
    }

    public Map<String, View> getViews(long app, String lang) {
        GetViewsRequest req = new GetViewsRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getViews(req).getViews();
    }

    public GetViewsResponseBody getViews(GetViewsRequest request) {
        return (GetViewsResponseBody)this.client.call(KintoneApi.GET_VIEWS, request, this.handlers);
    }

    public Map<String, View> getViewsPreview(long app) {
        return this.getViewsPreview(app, null);
    }

    public Map<String, View> getViewsPreview(long app, String lang) {
        GetViewsPreviewRequest req = new GetViewsPreviewRequest();
        req.setApp(app);
        req.setLang(lang);
        return this.getViewsPreview(req).getViews();
    }

    public GetViewsPreviewResponseBody getViewsPreview(GetViewsPreviewRequest request) {
        return (GetViewsPreviewResponseBody)this.client.call(KintoneApi.GET_VIEWS_PREVIEW, request, this.handlers);
    }

    public void revertApp(long app) {
        this.deployApp(app, null, true);
    }

    public void revertApp(long app, Long revision) {
        this.deployApp(app, revision, true);
    }

    public long updateAppAcl(long app, List<AppRightEntity> rights) {
        return this.updateAppAcl(app, rights, null);
    }

    public long updateAppAcl(long app, List<AppRightEntity> rights, Long revision) {
        UpdateAppAclRequest req = new UpdateAppAclRequest();
        req.setApp(app);
        req.setRights(rights);
        req.setRevision(revision);
        return this.updateAppAcl(req).getRevision();
    }

    public UpdateAppAclResponseBody updateAppAcl(UpdateAppAclRequest request) {
        return (UpdateAppAclResponseBody)this.client.call(KintoneApi.UPDATE_APP_ACL, request, this.handlers);
    }

    public Map<String, ActionId> updateAppActions(long app, Map<String, AppAction> actions) {
        UpdateAppActionsRequest req = new UpdateAppActionsRequest();
        req.setApp(app);
        req.setActions(actions);
        return this.updateAppActions(req).getActions();
    }

    public Map<String, ActionId> updateAppActions(long app, Map<String, AppAction> actions, Long revision) {
        UpdateAppActionsRequest req = new UpdateAppActionsRequest();
        req.setApp(app);
        req.setActions(actions);
        req.setRevision(revision);
        return this.updateAppActions(req).getActions();
    }

    public UpdateAppActionsResponseBody updateAppActions(UpdateAppActionsRequest request) {
        return (UpdateAppActionsResponseBody)this.client.call(KintoneApi.UPDATE_APP_ACTIONS, request, this.handlers);
    }

    public UpdateAppCustomizeResponseBody updateAppCustomize(UpdateAppCustomizeRequest request) {
        return (UpdateAppCustomizeResponseBody)this.client.call(KintoneApi.UPDATE_APP_CUSTOMIZE, request, this.handlers);
    }

    public UpdateAppSettingsResponseBody updateAppSettings(UpdateAppSettingsRequest request) {
        return (UpdateAppSettingsResponseBody)this.client.call(KintoneApi.UPDATE_APP_SETTINGS, request, this.handlers);
    }

    public long updateFieldAcl(long app, List<FieldRight> rights) {
        return this.updateFieldAcl(app, rights, null);
    }

    public long updateFieldAcl(long app, List<FieldRight> rights, Long revision) {
        UpdateFieldAclRequest req = new UpdateFieldAclRequest();
        req.setApp(app);
        req.setRights(rights);
        req.setRevision(revision);
        return this.updateFieldAcl(req).getRevision();
    }

    public UpdateFieldAclResponseBody updateFieldAcl(UpdateFieldAclRequest request) {
        return (UpdateFieldAclResponseBody)this.client.call(KintoneApi.UPDATE_FIELD_ACL, request, this.handlers);
    }

    public long updateFormFields(long app, List<FieldProperty> properties) {
        return this.updateFormFields(app, properties, null);
    }

    public long updateFormFields(long app, List<FieldProperty> properties, Long revision) {
        Map<String, FieldProperty> map = properties.stream().collect(Collectors.toMap(FieldProperty::getCode, v -> v));
        return this.updateFormFields(app, map, revision);
    }

    public long updateFormFields(long app, Map<String, FieldProperty> properties) {
        return this.updateFormFields(app, properties, null);
    }

    public long updateFormFields(long app, Map<String, FieldProperty> properties, Long revision) {
        UpdateFormFieldsRequest req = new UpdateFormFieldsRequest();
        req.setApp(app);
        req.setProperties(properties);
        req.setRevision(revision);
        return this.updateFormFields(req).getRevision();
    }

    public UpdateFormFieldsResponseBody updateFormFields(UpdateFormFieldsRequest request) {
        return (UpdateFormFieldsResponseBody)this.client.call(KintoneApi.UPDATE_FORM_FIELDS, request, this.handlers);
    }

    public long updateFormLayout(long app, List<Layout> layouts) {
        return this.updateFormLayout(app, layouts, null);
    }

    public long updateFormLayout(long app, List<Layout> layouts, Long revision) {
        UpdateFormLayoutRequest req = new UpdateFormLayoutRequest();
        req.setApp(app);
        req.setLayout(layouts);
        req.setRevision(revision);
        return this.updateFormLayout(req).getRevision();
    }

    public UpdateFormLayoutResponseBody updateFormLayout(UpdateFormLayoutRequest request) {
        return (UpdateFormLayoutResponseBody)this.client.call(KintoneApi.UPDATE_FORM_LAYOUT, request, this.handlers);
    }

    public UpdateGeneralNotificationsResponseBody updateGeneralNotifications(UpdateGeneralNotificationsRequest request) {
        return (UpdateGeneralNotificationsResponseBody)this.client.call(KintoneApi.UPDATE_GENERAL_NOTIFICATIONS, request, this.handlers);
    }

    public UpdatePerRecordNotificationsResponseBody updatePerRecordNotifications(UpdatePerRecordNotificationsRequest request) {
        return (UpdatePerRecordNotificationsResponseBody)this.client.call(KintoneApi.UPDATE_PRE_RECORD_NOTIFICATIONS, request, this.handlers);
    }

    public UpdateProcessManagementResponseBody updateProcessManagement(UpdateProcessManagementRequest request) {
        return (UpdateProcessManagementResponseBody)this.client.call(KintoneApi.UPDATE_PROCESS_MANAGEMENT, request, this.handlers);
    }

    public long updateRecordAcl(long app, List<RecordRight> rights) {
        return this.updateRecordAcl(app, rights, null);
    }

    public long updateRecordAcl(long app, List<RecordRight> rights, Long revision) {
        UpdateRecordAclRequest req = new UpdateRecordAclRequest();
        req.setApp(app);
        req.setRights(rights);
        req.setRevision(revision);
        return this.updateRecordAcl(req).getRevision();
    }

    public UpdateRecordAclResponseBody updateRecordAcl(UpdateRecordAclRequest request) {
        return (UpdateRecordAclResponseBody)this.client.call(KintoneApi.UPDATE_RECORD_ACL, request, this.handlers);
    }

    public UpdateReminderNotificationsResponseBody updateReminderNotifications(UpdateReminderNotificationsRequest request) {
        return (UpdateReminderNotificationsResponseBody)this.client.call(KintoneApi.UPDATE_REMINDER_NOTIFICATIONS, request, this.handlers);
    }

    public Map<String, ReportId> updateReports(long app, Map<String, Report> reports) {
        return this.updateReports(app, reports, null);
    }

    public Map<String, ReportId> updateReports(long app, Map<String, Report> reports, Long revision) {
        UpdateReportsRequest req = new UpdateReportsRequest();
        req.setApp(app);
        req.setReports(reports);
        req.setRevision(revision);
        return this.updateReports(req).getReports();
    }

    public UpdateReportsResponseBody updateReports(UpdateReportsRequest request) {
        return (UpdateReportsResponseBody)this.client.call(KintoneApi.UPDATE_REPORTS, request, this.handlers);
    }

    public Map<String, ViewId> updateViews(long app, Map<String, View> views) {
        return this.updateViews(app, views, null);
    }

    public Map<String, ViewId> updateViews(long app, Map<String, View> views, Long revision) {
        UpdateViewsRequest req = new UpdateViewsRequest();
        req.setApp(app);
        req.setViews(views);
        req.setRevision(revision);
        return this.updateViews(req).getViews();
    }

    public UpdateViewsResponseBody updateViews(UpdateViewsRequest request) {
        return (UpdateViewsResponseBody)this.client.call(KintoneApi.UPDATE_VIEWS, request, this.handlers);
    }

    @ConstructorProperties(value={"client", "handlers"})
    AppClient(InternalClient client, List<ResponseHandler> handlers) {
        this.client = client;
        this.handlers = handlers;
    }
}

