/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.kintone.client.exception.KintoneRuntimeException;
import com.kintone.client.model.app.AppFileIcon;
import com.kintone.client.model.app.AppIcon;
import com.kintone.client.model.app.AppPresetIcon;
import java.io.IOException;

class AppIconDeserializer
extends StdDeserializer<AppIcon> {
    private static final long serialVersionUID = 4465022900024070300L;

    AppIconDeserializer() {
        this(null);
    }

    AppIconDeserializer(Class<?> clazz) {
        super(clazz);
    }

    public AppIcon deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String type;
        ObjectCodec codec = p.getCodec();
        JsonNode node = (JsonNode)codec.readTree(p);
        switch (type = node.get("type").textValue()) {
            case "FILE": {
                return (AppIcon)codec.treeToValue((TreeNode)node, AppFileIcon.class);
            }
            case "PRESET": {
                return (AppIcon)codec.treeToValue((TreeNode)node, AppPresetIcon.class);
            }
        }
        throw new KintoneRuntimeException("Invalid icon type: " + type);
    }
}

