/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.InternalClient;
import com.kintone.client.ResponseHandler;
import com.kintone.client.api.common.DownloadFileRequest;
import com.kintone.client.api.common.DownloadFileResponseBody;
import com.kintone.client.api.common.UploadFileRequest;
import com.kintone.client.api.common.UploadFileResponseBody;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;

public class FileClient {
    private final InternalClient client;
    private final List<ResponseHandler> handlers;

    public InputStream downloadFile(String fileKey) throws IOException {
        DownloadFileRequest req = new DownloadFileRequest();
        req.setFileKey(fileKey);
        return this.downloadFile(req).getContent();
    }

    public DownloadFileResponseBody downloadFile(DownloadFileRequest request) {
        return this.client.download(request, this.handlers);
    }

    public String uploadFile(Path path, String contentType) throws IOException {
        UploadFileRequest req = new UploadFileRequest();
        req.setContentType(contentType);
        req.setFilename(path.getFileName().toString());
        try (InputStream content = Files.newInputStream(path, new OpenOption[0]);){
            req.setContent(content);
            String string = this.uploadFile(req).getFileKey();
            return string;
        }
    }

    public UploadFileResponseBody uploadFile(UploadFileRequest request) {
        return this.client.upload(request.getFilename(), request.getContentType(), request.getContent(), this.handlers).getBody();
    }

    @ConstructorProperties(value={"client", "handlers"})
    FileClient(InternalClient client, List<ResponseHandler> handlers) {
        this.client = client;
        this.handlers = handlers;
    }
}

