/*
 * Decompiled with CFR 0.152.
 */
package com.kintone.client;

import com.kintone.client.ConfigProperties;
import com.kintone.client.HttpResponseImpl;
import com.kintone.client.InternalClient;
import com.kintone.client.JsonMapper;
import com.kintone.client.KintoneApi;
import com.kintone.client.KintoneHttpMethod;
import com.kintone.client.ResponseHandler;
import com.kintone.client.Validator;
import com.kintone.client.api.KintoneRequest;
import com.kintone.client.api.KintoneResponse;
import com.kintone.client.api.KintoneResponseBody;
import com.kintone.client.api.common.BulkRequestsRequest;
import com.kintone.client.api.common.BulkRequestsResponseBody;
import com.kintone.client.api.common.DownloadFileRequest;
import com.kintone.client.api.common.DownloadFileResponseBody;
import com.kintone.client.api.common.UploadFileResponseBody;
import com.kintone.client.exception.KintoneRuntimeException;
import com.kintone.client.model.Auth;
import com.kintone.client.model.BasicAuth;
import com.kintone.client.model.BulkRequestContent;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.HttpMultipartMode;
import org.apache.hc.client5.http.entity.mime.InputStreamBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;

class InternalClientImpl
extends InternalClient {
    private final CloseableHttpClient httpClient;
    private final String baseUrl;
    private final Auth auth;
    private final BasicAuth basicAuth;
    private final Long guestId;
    private final String userAgent;
    private final JsonMapper mapper;
    private final HttpHost proxyHost;
    private final BasicScheme proxyAuth;

    InternalClientImpl(String baseUrl, Auth auth, BasicAuth basicAuth, URI proxyHost, BasicAuth proxyAuth, SSLContext sslContext, Long guestId, String appendixUserAgent, int connectionTimeout, int socketTimeout, int connectionRequestTimeout) {
        this.baseUrl = baseUrl;
        this.auth = auth;
        this.basicAuth = basicAuth;
        this.guestId = guestId;
        this.userAgent = InternalClientImpl.getUserAgent(appendixUserAgent);
        this.mapper = new JsonMapper();
        this.proxyHost = InternalClientImpl.createProxyHost(proxyHost);
        this.proxyAuth = InternalClientImpl.createPreemptiveProxyAuth(proxyAuth);
        this.httpClient = InternalClientImpl.createHttpClient(sslContext, this.proxyHost, connectionTimeout, socketTimeout, connectionRequestTimeout);
    }

    private static CloseableHttpClient createHttpClient(SSLContext sslContext, HttpHost proxyHost, int connTimeout, int socketTimeout, int connRequestTimeout) {
        RequestConfig.Builder configBuilder = RequestConfig.custom();
        configBuilder.setConnectTimeout((long)connTimeout, TimeUnit.MILLISECONDS);
        configBuilder.setConnectionRequestTimeout((long)connRequestTimeout, TimeUnit.MILLISECONDS);
        if (proxyHost != null) {
            configBuilder.setProxy(proxyHost);
            configBuilder.setProxyPreferredAuthSchemes(Collections.singleton("basic"));
        }
        PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setSslContext(sslContext).setTlsVersions(new TLS[]{TLS.V_1_3, TLS.V_1_2}).build()).setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(socketTimeout, TimeUnit.MILLISECONDS).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).build();
        HttpClientBuilder clientBuilder = HttpClients.custom();
        clientBuilder.setDefaultRequestConfig(configBuilder.build());
        clientBuilder.setConnectionManager((HttpClientConnectionManager)connectionManager);
        clientBuilder.disableRedirectHandling();
        return clientBuilder.build();
    }

    private static HttpHost createProxyHost(URI proxyHost) {
        if (proxyHost == null) {
            return null;
        }
        return new HttpHost(proxyHost.getScheme(), proxyHost.getHost(), proxyHost.getPort());
    }

    private static BasicScheme createPreemptiveProxyAuth(BasicAuth proxyAuth) {
        if (proxyAuth == null) {
            return null;
        }
        BasicScheme basicScheme = new BasicScheme();
        basicScheme.initPreemptive((Credentials)new UsernamePasswordCredentials(proxyAuth.getUser(), proxyAuth.getPassword().toCharArray()));
        return basicScheme;
    }

    private HttpContext createHttpContext() {
        HttpClientContext context = HttpClientContext.create();
        if (this.proxyHost != null && this.proxyAuth != null) {
            context.resetAuthExchange(this.proxyHost, (AuthScheme)this.proxyAuth);
        }
        return context;
    }

    @Override
    <T extends KintoneResponseBody> T call(KintoneApi api, KintoneRequest body, List<ResponseHandler> handlers) {
        String path = this.getApiPath(api);
        Class<? extends KintoneResponseBody> clazz = api.getResponseClass();
        return (T)this.call(api.getMethod(), path, body, clazz, handlers);
    }

    @Override
    <T extends KintoneResponseBody> T call(KintoneHttpMethod method, String path, KintoneRequest body, Class<T> clazz, List<ResponseHandler> handlers) {
        HttpUriRequest request = this.createJsonRequest(method, path, body);
        try {
            return (T)((KintoneResponseBody)this.httpClient.execute((ClassicHttpRequest)request, this.createHttpContext(), response -> {
                KintoneResponse result = this.parseJsonResponse(response, clazz);
                this.applyHandlers(result, handlers);
                return result.getBody();
            }));
        }
        catch (IOException e) {
            throw new KintoneRuntimeException("Failed to request", e);
        }
    }

    private Map<String, Object> headersToMap(Header[] headers) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Header header : headers) {
            result.put(header.getName(), header.getValue());
        }
        return Collections.unmodifiableMap(result);
    }

    private Map<String, Object> createBulkRequestBody(BulkRequestsRequest req) {
        ArrayList requestBodies = new ArrayList();
        for (BulkRequestContent content : req.getRequests()) {
            HashMap<String, Object> r = new HashMap<String, Object>();
            r.put("api", this.getApiPath(content.getApi()));
            r.put("method", (Object)content.getApi().getMethod());
            r.put("payload", content.getPayload());
            requestBodies.add(r);
        }
        return Collections.singletonMap("requests", requestBodies);
    }

    private List<KintoneResponseBody> parseBulkRequestResponse(List<BulkRequestContent> requests, List<Object> responses) {
        ArrayList<KintoneResponseBody> resultBodies = new ArrayList<KintoneResponseBody>();
        for (int i = 0; i < responses.size(); ++i) {
            Class<? extends KintoneResponseBody> responseClass = requests.get(i).getApi().getResponseClass();
            KintoneResponseBody body = this.mapper.convert(responses.get(i), responseClass);
            resultBodies.add(body);
        }
        return resultBodies;
    }

    @Override
    BulkRequestsResponseBody bulkRequest(BulkRequestsRequest body, List<ResponseHandler> handlers) {
        String path = this.getApiPath(KintoneApi.BULK_REQUESTS);
        HttpUriRequest request = this.createJsonRequest(KintoneApi.BULK_REQUESTS.getMethod(), path, this.createBulkRequestBody(body));
        try {
            return (BulkRequestsResponseBody)this.httpClient.execute((ClassicHttpRequest)request, this.createHttpContext(), response -> {
                KintoneResponse<BulkRequestsResponseBody> resp = this.parseResponse(response, stream -> {
                    Map responseMap = this.mapper.parse((InputStream)stream, Map.class);
                    List results = (List)responseMap.get("results");
                    List<KintoneResponseBody> bodies = this.parseBulkRequestResponse(body.getRequests(), results);
                    return new BulkRequestsResponseBody(Collections.unmodifiableList(bodies));
                });
                this.applyHandlers(resp, handlers);
                return resp.getBody();
            });
        }
        catch (IOException e) {
            throw new KintoneRuntimeException("Failed to request", e);
        }
    }

    @Override
    DownloadFileResponseBody download(DownloadFileRequest request, List<ResponseHandler> handlers) {
        KintoneResponse<DownloadFileResponseBody> r;
        String path = this.getApiPath(KintoneApi.DOWNLOAD_FILE);
        HttpUriRequest req = this.createJsonRequest(KintoneApi.DOWNLOAD_FILE.getMethod(), path, request);
        try {
            CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)req, this.createHttpContext());
            HttpResponseImpl resp = new HttpResponseImpl(response);
            r = this.parseResponse((ClassicHttpResponse)response, stream -> new DownloadFileResponseBody(resp));
        }
        catch (IOException e) {
            throw new KintoneRuntimeException("Failed to request", e);
        }
        this.applyHandlers(r, handlers);
        return r.getBody();
    }

    @Override
    KintoneResponse<UploadFileResponseBody> upload(String filename, String contentType, InputStream content, List<ResponseHandler> handlers) {
        String boundary = "__END_OF_PART__";
        Validator.checkContentType(contentType);
        Validator.checkFilename(filename);
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setCharset(StandardCharsets.UTF_8);
        builder.setBoundary(boundary);
        builder.setMode(HttpMultipartMode.LEGACY);
        builder.setContentType(ContentType.MULTIPART_FORM_DATA);
        builder.addPart("file", (ContentBody)new InputStreamBody(content, ContentType.create((String)contentType), filename));
        String headerContentType = "multipart/form-data; boundary=" + boundary;
        String path = this.getApiPath(KintoneApi.UPLOAD_FILE);
        HttpUriRequest httpRequest = this.createRequest(KintoneApi.UPLOAD_FILE.getMethod(), path, headerContentType, builder.build());
        try {
            return (KintoneResponse)this.httpClient.execute((ClassicHttpRequest)httpRequest, this.createHttpContext(), response -> {
                KintoneResponse<UploadFileResponseBody> r = this.parseJsonResponse(response, UploadFileResponseBody.class);
                this.applyHandlers(r, handlers);
                return r;
            });
        }
        catch (IOException e) {
            throw new KintoneRuntimeException("Failed to request", e);
        }
    }

    private static boolean isSuccess(int statusCode) {
        return 200 <= statusCode && statusCode < 300;
    }

    private <T extends KintoneResponseBody> KintoneResponse<T> parseResponse(ClassicHttpResponse response, Function<InputStream, T> converter) {
        int statusCode = response.getCode();
        Map<String, Object> headers = this.headersToMap(response.getHeaders());
        KintoneResponseBody result = null;
        String errorBody = null;
        try {
            if (InternalClientImpl.isSuccess(statusCode)) {
                result = (KintoneResponseBody)converter.apply(response.getEntity().getContent());
            } else {
                errorBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException | ParseException e) {
            throw new KintoneRuntimeException("Failed to request", e);
        }
        return new KintoneResponse<KintoneResponseBody>(statusCode, headers, result, errorBody);
    }

    private <T extends KintoneResponseBody> KintoneResponse<T> parseJsonResponse(ClassicHttpResponse response, Class<T> responseClass) {
        return this.parseResponse(response, stream -> (KintoneResponseBody)this.mapper.parse((InputStream)stream, responseClass));
    }

    private void applyHandlers(KintoneResponse<?> response, List<ResponseHandler> handlers) {
        for (ResponseHandler handler : handlers) {
            handler.handle(response);
        }
    }

    private String getApiPath(KintoneApi api) {
        if (this.guestId != null) {
            return "/k/guest/" + this.guestId + "/v1/" + api.getEndpoint() + ".json";
        }
        return "/k/v1/" + api.getEndpoint() + ".json";
    }

    private HttpUriRequest createRequest(KintoneHttpMethod method, String path, String contentType, HttpEntity entity) {
        URI uri = URI.create(this.baseUrl + path);
        HttpUriRequestBase request = new HttpUriRequestBase(method.toString(), uri);
        for (Map.Entry<String, String> header : this.auth.getHeaders().entrySet()) {
            request.addHeader(header.getKey(), (Object)header.getValue());
        }
        if (this.basicAuth != null) {
            String value = this.basicAuth.getUser() + ":" + this.basicAuth.getPassword();
            String token = Base64.getEncoder().encodeToString(value.getBytes());
            request.addHeader("Authorization", (Object)("Basic " + token));
        }
        request.addHeader("User-Agent", (Object)this.userAgent);
        if (entity != null) {
            request.addHeader("Content-Type", (Object)contentType);
        }
        request.setEntity(entity);
        return request;
    }

    private HttpUriRequest createJsonRequest(KintoneHttpMethod method, String path, Object body) {
        if (body == null) {
            return this.createRequest(method, path, null, null);
        }
        ByteArrayEntity entity = new ByteArrayEntity(this.mapper.format(body), ContentType.APPLICATION_JSON);
        return this.createRequest(method, path, ContentType.APPLICATION_JSON.getMimeType(), (HttpEntity)entity);
    }

    private static String getUserAgent(String appendixUserAgent) {
        String userAgent = "kintone-Java-Client@" + ConfigProperties.getVersion();
        if (appendixUserAgent != null && !appendixUserAgent.isEmpty()) {
            return userAgent + "/" + appendixUserAgent;
        }
        return userAgent;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }
}

